% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_country_info_mx.R
\name{get_country_info_mx}
\alias{get_country_info_mx}
\title{Get Country Information for Mexico}
\usage{
get_country_info_mx()
}
\value{
A tibble with one row containing Mexico's country information:
\describe{
  \item{name_common}{Common name of the country}
  \item{name_official}{Official name of the country}
  \item{region}{Geographic region}
  \item{subregion}{Geographic subregion}
  \item{capital}{Capital city(ies)}
  \item{area}{Total area in square kilometers}
  \item{population}{Total population}
  \item{languages}{Languages spoken (comma-separated)}
}
}
\description{
Retrieves comprehensive country information for Mexico from the REST Countries API.
This function fetches data including official and common names, geographical information,
capital, area, population, and languages.
}
\details{
This function makes a request to the REST Countries API v3.1 endpoint specifically
for Mexico using full text search. It handles API errors gracefully and
returns NULL if the request fails or no data is found.
}
\examples{
\donttest{
# Get Mexico information
mx_info <- get_country_info_mx()
print(mx_info)
}

}
