% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_tsne_pq}
\alias{plot_tsne_pq}
\title{Plot a tsne low dimensional representation of a phyloseq object}
\usage{
plot_tsne_pq(
  physeq,
  method = "bray",
  dims = 2,
  theta = 0,
  perplexity = 30,
  fact = NA,
  ellipse_level = 0.95,
  plot_dims = c(1, 2),
  na_remove = TRUE,
  force_factor = TRUE,
  ...
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{method}{A method to calculate distance using \code{vegan::vegdist()} function (default: "bray")}

\item{dims}{(Int) Output dimensionality (default: 2)}

\item{theta}{(Numeric) Speed/accuracy trade-off (increase for less accuracy), set to 0.0 for exact TSNE (default: 0.0 see details in the man page of \code{Rtsne::Rtsne}).}

\item{perplexity}{(Numeric) Perplexity parameter (should not be bigger than 3 * perplexity < nrow(X) - 1, see details in the man page of \code{Rtsne::Rtsne})}

\item{fact}{Name of the column in \code{physeq@sam_data} used to color points and compute ellipses.}

\item{ellipse_level}{The level used in stat_ellipse. Set to NULL to discard ellipse (default = 0.95)}

\item{plot_dims}{A vector of 2 values defining the rank of dimension to plot (default: c(1,2))}

\item{na_remove}{(logical, default TRUE) Does the samples with NA values in fact are removed? (default: true)}

\item{force_factor}{(logical, default TRUE) Force the fact column to be a factor.}

\item{...}{Additional arguments passed on to \code{Rtsne::Rtsne()}}
}
\value{
A ggplot object
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Partially inspired by \code{phylosmith::tsne_phyloseq()} function developed by Schuyler D. Smith.
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") withAutoprint(\{ # examplesIf}
data(data_fungi)
if (requireNamespace("Rtsne")) {
  plot_tsne_pq(data_fungi, fact = "Height", perplexity = 15)
}
\donttest{
if (requireNamespace("Rtsne")) {
  plot_tsne_pq(data_fungi, fact = "Time") + geom_label(aes(label = Sample_id, fill = Time))
  plot_tsne_pq(data_fungi, fact = "Time", na_remove = FALSE, force_factor = FALSE)
}
}
\dontshow{\}) # examplesIf}
}
\author{
Adrien Taudière
}
