% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets_misc.R
\name{sam_data_matching_names}
\alias{sam_data_matching_names}
\title{Match sample names from sam_data and fastq files}
\usage{
sam_data_matching_names(
  path_sam_data,
  sample_col_name,
  path_raw_seq,
  pattern_remove_sam_data = NULL,
  pattern_remove_fastq_files = NULL,
  verbose = TRUE,
  remove_undocumented_fastq_files = FALSE,
  prefix = NULL,
  ...
)
}
\arguments{
\item{path_sam_data}{(Required) Path to sample data file.}

\item{sample_col_name}{(Required) The name of the column defining sample names in the sample data file.}

\item{path_raw_seq}{(Required) Path to the folder containing fastq files}

\item{pattern_remove_sam_data}{If not null, describe the pattern that will be deleted from
sam_data samples names.}

\item{pattern_remove_fastq_files}{If not null, describe the pattern that will be deleted from
fastq files names.}

\item{verbose}{(logical, default TRUE) If TRUE, print some additional messages.}

\item{remove_undocumented_fastq_files}{(logical, default FALSE) If set to TRUE
fastq files not present in sam_data are removed from your folder.
Keep a copy of those files somewhere before.}

\item{prefix}{Add a prefix to new samples names (ex. prefix = "samp")}

\item{...}{Other parameters passed on to \code{\link[utils:read.table]{utils::read.csv()}} function.}
}
\value{
A list of two objects :
\itemize{
\item $sam_names_matching is a tibble of corresponding samples names
\item $sam_data is a sample data files including only matching sample names
}
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Useful for targets bioinformatic pipeline.
}
\author{
Adrien Taudière
}
