% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{save_pq}
\alias{save_pq}
\title{A wrapper of write_pq to save in all three possible formats}
\usage{
save_pq(physeq, path = NULL, ...)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{path}{a path to the folder to save the phyloseq object}

\item{...}{Additional arguments passed on to \code{\link[=write_pq]{write_pq()}} or \code{\link[utils:write.table]{utils::write.table()}} function.}
}
\value{
Build a folder (in path) with four csv tables (\code{refseq.csv}, \code{otu_table.csv}, \code{tax_table.csv}, \code{sam_data.csv}) + one
table with all tables together + a rdata file (\code{physeq.RData}) that can be loaded using
\code{\link[base:load]{base::load()}} function + if present a phylogenetic tree in Newick format (\code{phy_tree.txt})
}
\description{
A wrapper of write_pq to save in all three possible formats
}
\details{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


Write :
\itemize{
\item 4 separate tables
\item 1 table version
\item 1 RData file
}
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") withAutoprint(\{ # examplesIf}
save_pq(data_fungi, path = paste0(tempdir(), "/phyloseq"))
unlink(paste0(tempdir(), "/phyloseq"), recursive = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=write_pq]{write_pq()}}
}
\author{
Adrien Taudière
}
