% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.MuFiMeshGP.R
\name{update.MuFiMeshGP}
\alias{update.MuFiMeshGP}
\title{update.MuFiMeshGP}
\usage{
\method{update}{MuFiMeshGP}(object, x, t, y, param.estim = TRUE, init = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{MuFiMeshGP}.}

\item{x}{matrix of new input locations.}

\item{t}{new tunable parameter, a scalar.}

\item{y}{observation corresponding to input location \code{x} and tunable
parameter \code{t}.}

\item{param.estim}{if \code{TRUE}, the hyper-parameters are estimated by running it
through \code{\link{MuFiMeshGP}}. If \code{FALSE}, the hyper-parameters from
\code{object} are used to update the \code{MuFiMeshGP} model fit.}

\item{init}{See \code{\link{MuFiMeshGP}}.}

\item{...}{no other argument.}
}
\value{
a list which is given the S3 class "MuFiMeshGP"
}
\description{
The function updates the current \code{MuFiMeshGP} model.
}
\details{
Updates the \code{MuFiMeshGP} model fit with new observations

From the model fitted by \code{\link{MuFiMeshGP}} or \code{\link{update.MuFiMeshGP}}
 the posterior mean and standard deviation are calculated for any input
 location and fidelity level.
 For details, see Boutelet and Sung (2025, <arXiv:2503.23158>).
}
\examples{
# Example code

f <- function(x, t){
  x <- c(x)
  return(exp(-1.4*x)*cos(3.5*pi*x)+sin(40*x)/10*t^2)
}

set.seed(1)
X <- matrix(runif(15,0,1), ncol = 1)
tt <- runif(15,0.5,2)

Y <- f(c(X), tt)

fit.mufimeshgp <- MuFiMeshGP(X, tt, Y)

xx <- matrix(seq(0,1,0.01), ncol = 1)
ftrue <- f(xx, 0)

# predict
pred.mufimeshgp <- predict(fit.mufimeshgp, xx, rep(0,101))

mu <- pred.mufimeshgp$mean
s <- pred.mufimeshgp$sd
lower <- mu + qnorm(0.025)*s
upper <- mu + qnorm(0.975)*s

# plot

oldpar <- par(mfrow = c(1,2))
plot(xx, ftrue, "l", ylim = c(-1,1.3), ylab = "y", xlab = "x")
lines(c(xx), mu, col = "blue")
lines(c(xx), lower, col = "blue", lty = 2)
lines(c(xx), upper, col = "blue", lty = 2)
points(c(X), Y, col = "red")

### RMSE ###
print(sqrt(mean((ftrue - mu))^2))

best <- IMSPE_AL(fit.mufimeshgp, 0.5, 2, function(t) return(1 / t^2))
new.Y <- f(best$x, best$t)
fit.mufimeshgp <- update(fit.mufimeshgp, best$x, best$t, new.Y)

pred.mufimeshgp <- predict(fit.mufimeshgp, xx, rep(0, 101))
mu <- pred.mufimeshgp$mean
s <- pred.mufimeshgp$sd
lower <- mu + qnorm(0.025)*s
upper <- mu + qnorm(0.975)*s

plot(xx, ftrue, "l", ylim = c(-1,1.3), ylab = "y", xlab = "x")
lines(c(xx), mu, col = "blue")
lines(c(xx), lower, col = "blue", lty = 2)
lines(c(xx), upper, col = "blue", lty = 2)
points(c(X), Y, col = "red")
points(c(best$x), new.Y, col = "green")

par(oldpar)

### RMSE ###
print(sqrt(mean((ftrue - mu))^2))
}
\seealso{
\code{\link{MuFiMeshGP}} for initializing the model.
}
