% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPT_continuous_plot.R
\name{NPT_continuous_plot}
\alias{NPT_continuous_plot}
\title{Plot Continuous Niche Classification Results}
\usage{
NPT_continuous_plot(pca_obj, group = NULL, default_fill = "#1373D3")
}
\arguments{
\item{pca_obj}{The PCA result object from \code{NPT_continuous()$result}, which
should be a vegan rda object containing the second-level PCA results that
integrate all niche dimensions into a unified ordination space.}

\item{group}{Optional vector specifying group membership for each species/sample.
If provided, points will be colored by group. If NULL (default), all points
will have the same color. Length should match the number of rows in the
original data.}

\item{default_fill}{Character string specifying the default fill color when no
grouping is applied. Default is "#1373D3" (blue).}
}
\value{
A ggplot2 object containing the biplot visualization with:
\itemize{
\item Points representing species/samples in the ordination space
\item Arrows showing the direction and magnitude of niche dimension contributions
\item Labels for niche dimensions (arrows)
\item Variance explained by PC1 and PC2 in axis labels
\item Optional color coding by groups if provided
}
}
\description{
This function creates a biplot visualization of the continuous niche classification
results from the hierarchical Principal Component Analysis. It displays species
ordination in niche space with optional grouping and shows the contribution of
different niche dimensions as arrows.
}
\details{
The function creates a standard PCA biplot where:
\itemize{
\item Points represent species positioned in the integrated niche space
\item Red arrows represent the niche dimensions (from first-level PCAs) and
their relative contribution to the ordination axes
\item Arrow length indicates the strength of correlation with the ordination axes
\item Arrow direction shows the gradient direction in niche space
\item Dashed reference lines at x=0 and y=0 help interpret the ordination
}

The plot helps interpret:
\itemize{
\item Species clustering patterns in niche space
\item Which niche dimensions drive the main gradients
\item Relationships between different niche dimensions
\item Group differences in niche occupation (when groups are specified)
}
}
\note{
\itemize{
\item The function requires the result object from \code{NPT_continuous()}
\item A larger plotting window is recommended for better visualization
\item Arrow labels show dimension names (e.g., "pc1.grow", "pc2.survive")
\item The function uses \code{max.overlaps = Inf} to show all labels
\item Group colors are automatically assigned if groups are provided
}
}
\examples{
data(PFF)
PFF[,4:21] <- log(PFF[,4:21])
PFF <- na.omit(PFF)
traits_dimension <- list(
  grow = c("SLA","SRL","Leaf_Nmass","Root_Nmass"),
  survive = c("Height","Leaf_CN","Root_CN"),
  reproductive = c("SeedMass","FltDate","FltDur")
)
npt_result <- NPT_continuous(data = PFF, dimension = traits_dimension)
NPT_continuous_plot(npt_result$result)
NPT_continuous_plot(npt_result$result, PFF$family)

}
\references{
\enumerate{
\item Winemiller, K. O., Fitzgerald, D. B., Bower, L. M., & Pianka, E. R. (2015). Functional traits,
convergent evolution, and periodic tables of niches. Ecology letters, 18(8), 737-751.
\item Yu, R., Huang, J., Xu, Y., Ding, Y., & Zang, R. (2020). Plant functional niches in forests across
four climatic zones: Exploring the periodic table of niches based on plant functional traits.
Frontiers in Plant Science, 11, 841.
}
}
