% file MASS/birthwt.d
% copyright (C) 1994-8 W. N. Venables and B. D. Ripley
%
\name{birthwt}
\alias{birthwt}
\title{
Risk Factors Associated with Low Infant Birth Weight
}
\section{SUMMARY}{
The \code{birthwt} data frame has 189 rows and 10 columns.
The data were collected at Baystate Medical Center, Springfield, Mass
during 1986.
}
\section{DATA DESCRIPTION}{
This data frame contains the following columns:
}
\arguments{
\item{low}{
indicator of birth weight less than 2.5kg
}
\item{age}{
mother's age in years
}
\item{lwt}{
mother's weight in pounds at last menstrual period
}
\item{race}{
mother's race (\code{1} = white, \code{2} = black, \code{3} = other)
}
\item{smoke}{
smoking status during pregnancy
}
\item{ptl}{
number of previous premature labours
}
\item{ht}{
history of hypertension
}
\item{ui}{
presence of uterine irritability
}
\item{ftv}{
number of physician visits during the first trimester
}
\item{bwt}{
birth weight in grams
}}
\section{SOURCE}{
Hosmer, D.W. and Lemeshow, S. (1989)
\emph{Applied Logistic Regression.}
New York: Wiley
}
\examples{
attach(birthwt)
race <- factor(race, labels=c("white", "black", "other"))
ptd <- factor(ptl > 0)
ftv <- merge.levels(factor(ftv), c(1,2,3,3,3,3), c("0", "1", "2+"))
ftv <- factor(ftv)
levels(ftv)[-(1:2)] <- "2+"
bwt <- data.frame(low,age,lwt,race,smoke,ptd,ht,ui,ftv)
detach("birthwt")
options(contrasts = c("contr.treatment", "contr.poly"))
glm(low ~ ., binomial, bwt)
}
\keyword{datasets}
% Converted by Sd2Rd version 0.3-1.
