% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exclude_nca.R
\name{exclude_nca_by_param}
\alias{exclude_nca_by_param}
\title{Exclude NCA Results Based on Parameter Thresholds}
\usage{
exclude_nca_by_param(
  parameter,
  min_thr = NULL,
  max_thr = NULL,
  affected_parameters = parameter
)
}
\arguments{
\item{parameter}{The name of the PKNCA parameter to evaluate (e.g., "span.ratio").}

\item{min_thr}{The minimum acceptable value for the parameter. If not provided, is not applied.}

\item{max_thr}{The maximum acceptable value for the parameter. If not provided, is not applied.}

\item{affected_parameters}{Character vector of PKNCA parameters that will be marked as excluded.
By default is the defined parameter.}
}
\value{
A function that can be used with \code{PKNCA::exclude} to mark through the 'exclude'  column
the rows in the PKNCA results based on the specified thresholds for a parameter.
}
\description{
Exclude rows from NCA results based on specified thresholds for a given parameter.
This function allows users to define minimum and/or maximum acceptable values
for a parameter and excludes rows that fall outside these thresholds.
}
\examples{
# Example dataset
my_data <- PKNCA::PKNCAdata(
  PKNCA::PKNCAconc(data.frame(conc = 5:1,
                              time = 0:4,
                              subject = 1),
                   conc ~ time | subject),
  PKNCA::PKNCAdose(data.frame(subject = 1, dose = 100, time = 0),
                   dose ~ time | subject)
)
my_result <- PKNCA::pk.nca(my_data)

# Exclude rows where span.ratio is less than 2
excluded_result <- PKNCA::exclude(
  my_result,
  FUN = exclude_nca_by_param("span.ratio", min_thr = 2)
)
as.data.frame(excluded_result)

}
