% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PVBcorrect_functions.R
\name{acc_dg1}
\alias{acc_dg1}
\title{PVB correction by Begg and Greenes' method 1 (deGroot et al, no covariate)}
\usage{
acc_dg1(data, test, disease, description = TRUE)
}
\arguments{
\item{data}{A data frame, with at least "Test" and "Disease" variables.}

\item{test}{The "Test" variable name, i.e. the test result. The variable must be in binary; positive = 1, negative = 0 format.}

\item{disease}{The "Disease" variable name, i.e. the true disease status. The variable must be in binary; positive = 1, negative = 0 format.}

\item{description}{Print the name of this analysis. The default is \code{TRUE}. This can be turned off for repeated analysis, for example in bootstrapped results.}
}
\value{
A data frame object containing the accuracy results.
}
\description{
Perform PVB correction by Begg and Greenes' method 1 as described in deGroot et al (2011),
  in which it also includes PPV and NPV calculation.
}
\examples{
acc_dg1(data = cad_pvb, test = "T", disease = "D")  # equivalent to result by acc_ebg()
}
\references{
\enumerate{
  \item{de Groot, J. A. H., Janssen, K. J. M., Zwinderman, A. H., Bossuyt, P. M. M., Reitsma, J. B., & Moons, K. G. M. (2011). Correcting for partial verification bias: a comparison of methods. Annals of Epidemiology, 21(2), 139–148.}
}
}
