% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeaksAndTroughs.R
\name{find_peaks}
\alias{find_peaks}
\title{Find peaks in a data set}
\usage{
find_peaks(
  dataSet,
  xField,
  yField,
  minYerror = 0.1,
  minSlope = 0,
  asFraction = TRUE,
  maxPeakWidth = Inf,
  globalFilter = TRUE,
  ROI = c(NA, NA),
  edgeFilter = 0.02,
  justPeaks = TRUE
)
}
\arguments{
\item{dataSet}{The data to search}

\item{xField}{The name of the field to use as the x-value}

\item{yField}{The name of the field to use as the y-value}

\item{minYerror}{The minimum vertical separation between
adjacent peaks and troughs. If the difference is
less than this, they are filtered out as noise.
If \code{asFraction} is true, this is multiplied by the
total y-axis range (y-range) of the data.}

\item{minSlope}{The minimum slope between adjacent peaks
and troughs. Useful when adjacent peaks and troughs
are far apart along the x-axis. If \code{asFraction}
is true, this is multiplied by the y-range/x-range
of the data.}

\item{asFraction}{Whether to interpret the \code{minYerror},
\code{minSlope}, \code{edgeFilter}, and \code{maxPeakWidth}
arguments as fractions of the total dimensions
of the data (\code{TRUE}) or just as absolute values
(\code{FALSE})}

\item{maxPeakWidth}{The maximum width a peak can have.
Useful for preventing the function from interpreting
a long, flat plateau as a peak.}

\item{globalFilter}{Whether to apply the global filter
(\code{TRUE}) or just compare peaks and troughs to
adjacent peaks and troughs (\code{FALSE})}

\item{ROI}{Region of interest. Specifies the range of
x-values that the function sees. Use the format
\code{ROI = c(min, max)}. If this parameter is used,
the \code{edgeFilter} parameter is ignored.}

\item{edgeFilter}{Removes peaks and troughs within this
distance of the edge of the data set. If
\code{asFraction} is true, this is multiplied by the
x-range of the data. This filter is only applied after
the data has been processed.}

\item{justPeaks}{Whether to return only the peaks (\code{TRUE})
or also the troughs (\code{FALSE})}
}
\value{
A data frame containing the peaks of the data.
}
\description{
\code{find_peaks} finds the peaks, and troughs if requested, of a data set.
}
\details{
The filter is implemented by comparing pairs of peaks
to a hyperbola determined by the y-intercept (\code{minYerror}),
and the slope (\code{minSlope}). The user can employ either an
edge filter or a region of interest (\code{ROI}) to filter out
certain regions. The difference is that the edge
filter waits for the data to be processed, then
removes the peaks within a certain distance of the edges.
The region of interest lets the user specify a region of the
data, and the function removes everything outside that region
before doing any analysis.
}
