% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-venn.R
\name{plotVennPathway}
\alias{plotVennPathway}
\title{Plot Venn diagram from multiple pathway analysis results}
\usage{
plotVennPathway(PAResults, pThreshold = 0.05, useFDR = TRUE, topToList = 10)
}
\arguments{
\item{PAResults}{A list of data frames with the results of pathway analysis.}

\item{pThreshold}{The p-value threshold to determine if a pathway is enriched.}

\item{useFDR}{Use the FDR adjusted p-value instead of the raw p-value.}

\item{topToList}{The number of common signifcant pathways that are used to annotate the plot.}
}
\value{
A ggplot2 object.
}
\description{
Plot a Venn diagram from multiple pathway analysis results.
}
\examples{
\donttest{
library(RCPA)


affyFgseaResult <- loadData("affyFgseaResult")
agilFgseaResult <- loadData("agilFgseaResult")
RNASeqFgseaResult <- loadData("RNASeqFgseaResult")
metaPAResult <- loadData("metaPAResult")

PAResults <- list(
    "Affymetrix - GSE5281" = affyFgseaResult,
    "Agilent - GSE61196" = agilFgseaResult,
    "RNASeq - GSE153873" = RNASeqFgseaResult,
    "Meta-analysis" = metaPAResult
)

PAREsultUps <- lapply(PAResults, function(df) df[df$normalizedScore > 0,])

PAREsultDowns <- lapply(PAResults, function(df) df[df$normalizedScore < 0,])

if (require("ggvenn", quietly = TRUE)){
p1 <- RCPA::plotVennPathway(PAResults, pThreshold = 0.05) +
    ggplot2::ggtitle("All Significant Pathways")
p2 <- RCPA::plotVennPathway(PAREsultUps, pThreshold = 0.05) +
    ggplot2::ggtitle("Significantly Up-regulated Pathways")
p3 <- RCPA::plotVennPathway(PAREsultDowns, pThreshold = 0.05) +
    ggplot2::ggtitle("Significantly Down-regulated Pathways")
}
}
}
