% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best.rsa2.R
\name{best.rsa2}
\alias{best.rsa2}
\title{Compare two polynomial models against the data}
\usage{
best.rsa2(RSA_object, m1, m2, order = c("wAIC"), robust = F)
}
\arguments{
\item{RSA_object}{x an object of class "RSA_object" generated by RSAmodel()}

\item{m1}{First model to be compared (contained in RSA_object$models)}

\item{m2}{Second model to be compared (contained in RSA_object$models)}

\item{order}{Fit index used to determine best-fitting model.}

\item{robust}{A boolean stating whether robust fit indices should be extracted (default= TRUE)}
}
\value{
A table containing fit indices for each model
}
\description{
Compare two polynomial models, for example to test parametric constraints in STEP2 of the 3-step identification strategy (see \code{\link{RSAmodel}}).
}
\examples{
##### Test a variant within a family (e.g., FM26_PARALLELASYMWEAK)
##Define variant as constraints
list_variant <- list()
list_variant[["variant1"]] <- c('
####First-order polynomials: variant-specific			
			b1 == -1/4*b2
####Second-order polynomials: variant-specific			
			b5 == b3/2
			b4 == 0
####Third-order polynomials: FM26_PARALLELASYMWEAK			
			b6 == 0
			b7 == 0
			b9 == b8/-3		
')
RSA_NSfit  <- RSAmodel(formula= engagement ~ needs*supplies,
data= sim_NSfit, model= c("FM26_PARALLELASYMWEAK","USER"),
user_model= list_variant)
##Compare variant to best-fitting family (e.g., LRT_pvalue p > .05)
best.rsa2(RSA_NSfit,m1="variant1",m2="FM26_PARALLELASYMWEAK")[2,1:3]
}
