% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zibeta2.R
\name{zibeta2}
\alias{zibeta2}
\alias{dzibeta2}
\alias{pzibeta2}
\alias{rzibeta2}
\title{Reparameterised zero-inflated beta distribution}
\usage{
dzibeta2(x, mu, phi, zeroprob = 0, log = FALSE)

pzibeta2(q, mu, phi, zeroprob = 0, lower.tail = TRUE, log.p = FALSE)

rzibeta2(n, mu, phi, zeroprob = 0)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{mean parameter, must be in the interval from 0 to 1.}

\item{phi}{concentration parameter, must be positive.}

\item{zeroprob}{zero-inflation probability between 0 and 1.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \le x]}, otherwise \eqn{P[X > x]}.}

\item{n}{number of random values to return.}

\item{p}{vector of probabilities}
}
\value{
\code{dzibeta2} gives the density, \code{pzibeta2} gives the distribution function, and \code{rzibeta2} generates random deviates.
}
\description{
Density, distribution function, and random generation for
the zero-inflated beta distribution reparameterised in terms of mean and concentration.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
set.seed(123)
x <- rzibeta2(1, 0.5, 1, 0.5)
d <- dzibeta2(x, 0.5, 1, 0.5)
p <- pzibeta2(x, 0.5, 1, 0.5)
}
