% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ziinvgauss.R
\name{ziinvgauss}
\alias{ziinvgauss}
\alias{dziinvgauss}
\alias{pziinvgauss}
\alias{rziinvgauss}
\title{Zero-inflated inverse Gaussian distribution}
\usage{
dziinvgauss(x, mean = 1, shape = 1, zeroprob = 0, log = FALSE)

pziinvgauss(q, mean = 1, shape = 1, zeroprob = 0, lower.tail = TRUE, log.p = FALSE)

rziinvgauss(n, mean = 1, shape = 1, zeroprob = 0)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mean}{location parameter}

\item{shape}{shape parameter, must be positive.}

\item{zeroprob}{zero-probability, must be in \eqn{[0, 1]}.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return}
}
\value{
\code{dziinvgauss} gives the density, \code{pziinvgauss} gives the distribution function, and \code{rziinvgauss} generates random deviates.
}
\description{
Density, distribution function, and random generation for
the zero-inflated inverse Gaussian distribution.
}
\details{
This implementation of \code{zidinvgauss} allows for automatic differentiation with \code{RTMB}.
}
\examples{
x <- rziinvgauss(1, 1, 2, 0.5)
d <- dziinvgauss(x, 1, 2, 0.5)
p <- pziinvgauss(x, 1, 2, 0.5)
}
