% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztpois.R
\name{ztpois}
\alias{ztpois}
\alias{dztpois}
\alias{pztpois}
\alias{rztpois}
\title{Zero-truncated Poisson distribution}
\usage{
dztpois(x, lambda, log = FALSE)

pztpois(q, lambda, lower.tail = TRUE, log.p = FALSE)

rztpois(n, lambda)
}
\arguments{
\item{x, q}{integer vector of counts}

\item{lambda}{vector of (non-negative) means}

\item{log, log.p}{logical; return log-density if TRUE}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}
}
\value{
\code{dztpois} gives the probability mass function, \code{pztpois} gives the distribution function, and \code{rztpois} generates random deviates.
}
\description{
Probability mass function, distribution function, and random generation for
the zero-truncated Poisson distribution.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.

By definition, this distribution only has support on the positive integers (1, 2, ...).
Any zero-truncated distribution is defined as
\deqn{P(X=x | X>0) = P(X=x) / (1 - P(X=0)),}
where \eqn{P(X=x)} is the probability mass function of the corresponding untruncated distribution.
}
\examples{
set.seed(123)
x <- rztpois(1, 0.5)
d <- dztpois(x, 0.5)
p <- pztpois(x, 0.5)
}
