% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-random-discrete-walk.R
\name{discrete_walk}
\alias{discrete_walk}
\title{Discrete Sampled Walk}
\usage{
discrete_walk(
  .num_walks = 25,
  .n = 100,
  .upper_bound = 1,
  .lower_bound = -1,
  .upper_probability = 0.5,
  .initial_value = 100,
  .dimensions = 1
)
}
\arguments{
\item{.num_walks}{Total number of simulations.}

\item{.n}{Total time of the simulation.}

\item{.upper_bound}{The upper bound of the random walk.}

\item{.lower_bound}{The lower bound of the random walk.}

\item{.upper_probability}{The probability of the upper bound. Default is 0.5.
The lower bound is calculated as 1 - .upper_probability.}

\item{.initial_value}{The initial value of the random walk. Default is 100.}

\item{.dimensions}{The default is 1. Allowable values are 1, 2 and 3.}
}
\value{
A tibble containing the generated random walks with columns depending
on the number of dimensions:
\itemize{
\item \code{walk_number}: Factor representing the walk number.
\item \code{step_number}: Step index.
\item \code{y}: If \code{.dimensions = 1}, the value of the walk at each step.
\item \code{x}, \code{y}: If \code{.dimensions = 2}, the values of the walk in two dimensions.
\item \code{x}, \code{y}, \code{z}: If \code{.dimensions = 3}, the values of the walk in three dimensions.
}

The following are also returned based upon how many dimensions there are and could be any of x, y and or z:
\itemize{
\item \code{cum_sum}: Cumulative sum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_prod}: Cumulative product of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_min}: Cumulative minimum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_max}: Cumulative maximum of \code{dplyr::all_of(.dimensions)}.
\item \code{cum_mean}: Cumulative mean of \code{dplyr::all_of(.dimensions)}.
}
}
\description{
The \code{discrete_walk} function generates multiple random walks over discrete time periods.
Each step in the walk is determined by a probabilistic sample from specified upper and lower bounds.
This function is useful for simulating stochastic processes, such as stock price movements or
other scenarios where outcomes are determined by a random process.
}
\details{
The function \code{discrete_walk} simulates random walks for a specified number of simulations
(\code{.num_walks}) over a given total time (\code{.n}). Each step in the walk is either the upper
bound or the lower bound, determined by a probability (\code{.upper_probability}). The initial
value of the walk is set by the user (\code{.initial_value}), and the cumulative sum, product,
minimum, and maximum of the steps are calculated for each walk. The results are returned
in a tibble with detailed attributes, including the parameters used for the simulation.
}
\examples{
set.seed(123)
discrete_walk()

set.seed(123)
discrete_walk(.dimensions = 3) |>
  head() |>
  t()

}
\seealso{
Other Generator Functions: 
\code{\link{brownian_motion}()},
\code{\link{geometric_brownian_motion}()},
\code{\link{random_beta_walk}()},
\code{\link{random_binomial_walk}()},
\code{\link{random_cauchy_walk}()},
\code{\link{random_chisquared_walk}()},
\code{\link{random_displacement_walk}()},
\code{\link{random_exponential_walk}()},
\code{\link{random_f_walk}()},
\code{\link{random_gamma_walk}()},
\code{\link{random_geometric_walk}()},
\code{\link{random_hypergeometric_walk}()},
\code{\link{random_logistic_walk}()},
\code{\link{random_lognormal_walk}()},
\code{\link{random_multinomial_walk}()},
\code{\link{random_negbinomial_walk}()},
\code{\link{random_normal_drift_walk}()},
\code{\link{random_normal_walk}()},
\code{\link{random_poisson_walk}()},
\code{\link{random_smirnov_walk}()},
\code{\link{random_t_walk}()},
\code{\link{random_uniform_walk}()},
\code{\link{random_weibull_walk}()},
\code{\link{random_wilcox_walk}()},
\code{\link{random_wilcoxon_sr_walk}()}

Other Discrete Distribution: 
\code{\link{random_binomial_walk}()},
\code{\link{random_displacement_walk}()},
\code{\link{random_geometric_walk}()},
\code{\link{random_hypergeometric_walk}()},
\code{\link{random_multinomial_walk}()},
\code{\link{random_negbinomial_walk}()},
\code{\link{random_poisson_walk}()},
\code{\link{random_smirnov_walk}()},
\code{\link{random_wilcox_walk}()},
\code{\link{random_wilcoxon_sr_walk}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Discrete Distribution}
\concept{Generator Functions}
