% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate.fuzzycoco_fit}
\alias{evaluate.fuzzycoco_fit}
\title{evaluate the fuzzy system from a fit on some given data}
\usage{
\method{evaluate}{fuzzycoco_fit}(x, data, verbose = FALSE, ...)
}
\arguments{
\item{x}{the fuzzycoco_fit object containing the fuzzy system to evaluate}

\item{data}{the data to evaluate the fuzzy system on}

\item{verbose}{whether to be verbose}

\item{...}{not used. Only for S3 generic consistency}
}
\value{
the evaluation as a named list:
\itemize{
\item fitness: the fitness value
\item metrics: the evaluation metrics as a named list
}
}
\description{
N.B: just a S3 method method wrapping the \code{\link[=evaluate_fuzzy_system]{evaluate_fuzzy_system()}} function
}
\examples{
model <- fuzzycoco("regression", example_mtcars()$params, seed = 123)
df <- mtcars[c("mpg", "hp", "wt", "qsec")]
fit <- fit(model, qsec ~ ., df, engine = "rcpp", seed = 456, max_generations = 20)

res <- evaluate(fit, df)
print(res$fitness)
}
