% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_posterior.R
\name{extract_posterior}
\alias{extract_posterior}
\title{Extract Posterior Samples from a RoBMA Model}
\usage{
extract_posterior(
  x,
  parameter = "mu",
  conditional = FALSE,
  output_scale = NULL,
  ...
)
}
\arguments{
\item{x}{a fitted RoBMA object}

\item{parameter}{a parameter for which posterior samples
should be extracted. Defaults to \code{"mu"} (for the effect size).
The additional options  are \code{"tau"} (for the heterogeneity),
\code{"weightfunction"} (for the estimated weightfunction),
or \code{"PET"} and \code{"PEESE"} (for the PET-PEESE coefficients).}

\item{conditional}{whether conditional estimates should be
extracted. Defaults to \code{FALSE} which extracts the model-averaged
estimates. Note that both \code{"weightfunction"} and
\code{"PET-PEESE"} are always ignoring the other type of
publication bias adjustment.}

\item{output_scale}{transform the effect sizes and the meta-analytic
effect size estimate to a different scale. Defaults to \code{NULL}
which returns the same scale as the model was estimated on.}

\item{...}{additional arguments passed to the method.}
}
\value{
A matrix containing the posterior samples for the specified parameter.
}
\description{
Extracts posterior samples for a specified parameter from a RoBMA model object.
}
\examples{
\dontrun{
# Assuming 'fit' is a fitted RoBMA model:
posterior_mu <- extract_posterior(fit, parameter = "mu")
}

}
