% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{set_default_priors}
\alias{set_default_priors}
\title{Set default prior distributions}
\usage{
set_default_priors(parameter, null = FALSE, rescale = 1)
}
\arguments{
\item{parameter}{a character string specifying the parameter for
which the prior distribution should be set. Available options are
"effect", "heterogeneity", "bias", "hierarchical", "covariates",
"factors".}

\item{null}{a logical indicating whether the prior distribution
should be set for the null hypothesis. Defaults to \code{FALSE}.}

\item{rescale}{a numeric value specifying the re-scaling factor
for the default prior distributions. Defaults to 1. Allows
convenient re-scaling of prior distributions simultaneously.}
}
\value{
A prior distribution object or a list of prior distribution
objects.
}
\description{
Set default prior distributions for RoBMA models.
}
\details{
The default prior distributions corresponds to the
specification of RoBMA-PSMA and RoBMA-regression outlined in
\insertCite{bartos2021no;textual}{RoBMA} and
\insertCite{bartos2023robust;textual}{RoBMA}.

Specifically, the prior distributions are:

\strong{For the alternative hypothesis:}
\itemize{
\item \strong{Effect:} Normal distribution with mean 0 and standard deviation 1.
\item \strong{Heterogeneity:} Inverse gamma distribution with shape 1 and scale 0.15.
\item \strong{Bias:} A list of 8 prior distributions defining the publication bias adjustments:
\itemize{
\item Two-sided: Weight function with steps 0.05.
\item Two-sided: Weight function with steps 0.05 and 0.1.
\item One-sided: Weight function with steps 0.05.
\item One-sided: Weight function with steps 0.025 and 0.05.
\item One-sided: Weight function with steps 0.05 and 0.5.
\item One-sided: Weight function with steps 0.025, 0.05, and 0.5.
\item PET-type model with regression coefficient: Cauchy distribution with location 0 and scale 1.
\item PEESE-type model with regression coefficient: Cauchy distribution with location 0 and scale 5.
}
All weight functions use a unit cumulative Dirichlet prior distribution on relative prior probabilities.
\item \strong{Standardized continuous covariates:} Normal distribution with mean 0 and standard deviation 0.25.
\item \strong{Factors (via by-level differences from the grand mean):} Normal distribution with mean 0 and standard deviation 0.25.
}

\strong{For the null hypothesis:}
\itemize{
\item \strong{Effect:} Point distribution at 0.
\item \strong{Heterogeneity:} Point distribution at 0.
\item \strong{Bias:} No prior distribution.
\item \strong{Standardized continuous covariates:} Point distribution at 0.
\item \strong{Factors (via by-level differences from the grand mean):} Point distribution at 0.
}

The rescaling factor adjusts the width of the effect, heterogeneity, covariates, factor, and PEESE-style model prior distributions.
PET-style and weight function prior distributions are scale-invariant.
}
\examples{

set_default_priors("effect")
set_default_priors("heterogeneity")
set_default_priors("bias")

}
