% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNeighborCoords.R
\name{getNeighborCoords}
\alias{getNeighborCoords}
\title{Get coordinates of neighbors of specified distance}
\usage{
getNeighborCoords(
  center,
  radius,
  dims_px = c(1000, 1000),
  type = "ring",
  tol = "strict",
  tol_val = 0.5
)
}
\arguments{
\item{center}{Numeric vector of length two specifying the coordinates
(in pixels) of the center point.}

\item{radius}{Integer value specifying the radius (in pixels). A radius of
0 returns only the center point itself.}

\item{dims_px}{Numeric vector of length two (default: 1,000 x 1,000)
specifying the dimensions (in pixels). Neighbors outside are ignored.}

\item{type}{Character, "ring" (default) or "area", specifying if the
pixel coordinates of only the outer ring or of the whole circle area should
be returned.}

\item{tol}{Character, "strict" (default) or "loose", specifying how thick
the ring/outer edge of the area should be, i.e., if pixels
close but not exactly on the circle should be included. If set to "loose",
all pixels that touch the circle are included. If set to "strict", only
additional pixels whose centers have a distance of at most \code{tol_val}
to the circle are included.}

\item{tol_val}{Numeric value specifying the tolerance value (>=0,<1,
default: 0.5), i.e., pixels are considered neighbors if the difference
between their Euclidean distance to the center and the radius is less than
or equal to the tolerance value.
Only applies if \code{tol} is set to "strict". \cr
A radius of 1 with a tolerance of 0.5 returns all 8 surrounding pixels and
with a tolerance of 0 only the 4 orthogonally neighboring pixels.}
}
\value{
\code{getNeighborCoords} Numeric matrix with two columns containing
the neighbors' coordinates (in pixels).
}
\description{
\code{getNeighborCoords} - Returns coordinates of all pixels in a two
dimensional raster/image/... with a specified Euclidean distance from the
center, i.e., a pixel circle, either a ring or the whole area with a
specified radius.
}
\examples{
# The neighbors with radius 1 of point (4,4) in an 8x8 grid.
# With tolerance 0.5:
test <- matrix(0, nrow = 8, ncol = 8)
test[getNeighborCoords(c(4,4), 1, c(8,8))] <- 1
test
# With tolerance 0.4:
test <- matrix(0, nrow = 8, ncol = 8)
test[getNeighborCoords(c(4,4), 1, c(8,8), tol_val = 0.4)] <- 1
test
}
