% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RprobitB_parameter.R
\name{RprobitB_parameter}
\alias{RprobitB_parameter}
\alias{print.RprobitB_parameter}
\title{Define probit model parameter}
\usage{
RprobitB_parameter(
  P_f,
  P_r,
  J,
  N,
  C = 1,
  ordered = FALSE,
  alpha = NULL,
  s = NULL,
  b = NULL,
  Omega = NULL,
  Sigma = NULL,
  Sigma_full = NULL,
  beta = NULL,
  z = NULL,
  d = NULL,
  sample = TRUE
)

\method{print}{RprobitB_parameter}(x, ..., digits = 4)
}
\arguments{
\item{P_f}{[\code{integer(1)}]\cr
The number of covariates connected to a fixed coefficient.}

\item{P_r}{[\code{integer(2)}]\cr
The number of covariates connected to a random coefficient.}

\item{J}{[\code{integer(1)}]\cr
The number >= 2 of choice alternatives.}

\item{N}{[\code{integer(1)}]\cr
The number of decision makers.}

\item{C}{[\code{integer(1)}]\cr
The number (greater or equal 1) of latent classes of decision makers.}

\item{ordered}{[\code{logical(1)}]\cr
If \code{TRUE}, the choice set \code{alternatives} is assumed to be ordered
from worst to best.}

\item{alpha}{[\code{numeric(P_f)}]\cr
The fixed coefficient vector.}

\item{s}{[\code{numeric(C)}]\cr
The vector of class weights.}

\item{b}{[\code{matrix(nrow = P_r, ncol = C)}]\cr
The matrix of class means as columns.}

\item{Omega}{[\code{matrix(nrow = P_r * P_r, ncol = C)}]\cr
The matrix of vectorized class covariance matrices as columns.}

\item{Sigma}{[\code{matrix(nrow = J - 1, ncol = J - 1)} | \code{numeric(1)}]\cr
The differenced (wrt. alternative \code{J}) error covariance matrix.

In case of \code{ordered = TRUE}, the single error variance.}

\item{Sigma_full}{[\code{matrix(nrow = J, ncol = J)}]\cr
The error covariance matrix.

Ignored if \code{Sigma} is specified or \code{ordered = TRUE}.

Internally, \code{Sigma_full} gets differenced wrt.  alternative \code{J}.}

\item{beta}{[\code{matrix(nrow = P_r, ncol = N)}]\cr
The matrix of the decider-specific coefficient vectors.}

\item{z}{[\code{numeric(N)}]\cr
The decider class allocations.}

\item{d}{[\code{numeric(J - 2)}]\cr
The logarithmic increases of the utility thresholds in the ordered probit
case (\code{ordered = TRUE}).}

\item{sample}{[\code{logical(1)}]\cr
Sample missing parameters?}

\item{x}{An \code{RprobitB_parameter} object.}

\item{...}{[\code{character()}]\cr
Names of parameters to be printed. If not specified, all parameters are
printed.}

\item{digits}{[\code{integer(1)}]\cr
The number of decimal places.}
}
\value{
An object of class \code{RprobitB_parameter}, which is a named list with the
model parameters.
}
\description{
This function creates an object of class \code{RprobitB_parameter}, which
contains the parameters of a probit model.

If \code{sample = TRUE}, missing parameters are sampled. All parameters are
checked against the values of \code{P_f}, \code{P_r}, \code{J}, and \code{N}.

Note that parameters are automatically ordered with respect to a
non-ascending \code{s} for class identifiability.
}
\examples{
RprobitB_parameter(P_f = 1, P_r = 2, J = 3, N = 10, C = 2)
}
