% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs_sintax.R
\name{make_sintax_db}
\alias{make_sintax_db}
\alias{sintax_db}
\title{Make Sintax database}
\usage{
make_sintax_db(taxonomy_table, outfile)
}
\arguments{
\item{taxonomy_table}{(Required). A data.frame with sequences and proper
information for making a Sintax database, see \emph{Details}.}

\item{outfile}{(Required). Name of database file to create (a FASTA file).}
}
\value{
No return in R, but a FASTA file (\code{outfile}) with properly
formatted \code{Header} lines is created.
}
\description{
Creates a properly formatted FASTA file for the use as a Sintax
database.
}
\details{
The Sintax algorithm is used by \code{VSEARCH} to assign taxonomic
information to 16S sequences. It requires a database, which is nothing but a
FASTA file of 16S sequences with properly formatted \code{Header}-lines.

The \code{taxonomy_table} provided as input here must have the columns:

\itemize{
 \item \code{Header} - short unique text for each sequence
 \item \code{Sequence} - the sequences
 \item Columns \code{domain}, \code{phylum}, \code{class}, \code{order},
  \code{family}, \code{genus}, \code{species}. Text columns with taxon names.
}

In some taxonomies the domain rank is named kingdom, but here we use the
word domain. You may very well have empty (NA) entries in the taxonomy
columns of the table.
}
\examples{
\dontrun{
# First, you need a table of the same format as output by vs_sintax:
db.file <- file.path(file.path(path.package("Rsearch"), "extdata"),
                     "sintax_db.fasta")
fasta.file <- file.path(file.path(path.package("Rsearch"), "extdata"),
                        "small.fasta")
tax.tbl <- vs_sintax(fasta_input = fasta.file, database = db.file)

# Inspect tax.tbl to see its columns. You replace the column content with
# your desired taxonomy.
# From such a tax.tbl you create the database file:
make_sintax_db(tax.tbl, outfile = "delete_ma.fasta")
}

}
\references{
\url{https://www.biorxiv.org/content/10.1101/074161v1}
}
