% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_metrics.R
\name{calculate_metrics}
\alias{calculate_metrics}
\title{Calculation of spatial search path metrics.}
\usage{
calculate_metrics(path, arena)
}
\arguments{
\item{path}{An \code{rtrack_path} object as returned by
\code{\link{read_path}}.}

\item{arena}{An \code{rtrack_arena} object as returned by
\code{\link{read_arena}}.}
}
\value{
An \code{rtrack_metrics} object containing metrics of the search path.
 This object is required as input for the \code{\link{call_strategy}} and
 \code{\link{plot_path}} functions.
}
\description{
Calculates a range of metrics from path coordinates.
}
\details{
Metrics are calculated based on normalised coordinate data and are made
accessible to machine learning algorithms in the \code{features} element of
the \code{rtrack_path} object. A relevant selection of metrics (with the same
units as the raw data) is also available as the \code{summary} element. These
can be useful for custom plots and are also the values exported by
\code{\link{export_results}}. Extended metrics are also available as separate
elements of the \code{rtrack_metrics} object.
}
\examples{
require(Rtrack)
track_file <- system.file("extdata", "Track_1.tab", package = "Rtrack")
arena_description <- system.file("extdata", "Arena.txt", package = "Rtrack")
arena <- read_arena(arena_description)
path <- read_path(track_file, arena, track.format = "raw.tab")
metrics <- calculate_metrics(path, arena)

}
\seealso{
\code{\link{read_path}}, \code{\link{read_arena}}, and also
 \code{\link{read_experiment}} for processing many tracks at once.
}
