% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_DimPlot.R
\name{do_DimPlot}
\alias{do_DimPlot}
\title{Wrapper for \link[Seurat]{DimPlot}.}
\usage{
do_DimPlot(
  sample,
  reduction = NULL,
  group.by = NULL,
  split.by = NULL,
  split.by.combined = TRUE,
  colors.use = NULL,
  colorblind = FALSE,
  shuffle = TRUE,
  order = NULL,
  raster = FALSE,
  pt.size = 1,
  label = FALSE,
  label.color = "black",
  label.fill = "white",
  label.size = 4,
  label.box = TRUE,
  repel = FALSE,
  cells.highlight = NULL,
  idents.highlight = NULL,
  idents.keep = NULL,
  sizes.highlight = 1,
  ncol = NULL,
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  legend.title = NULL,
  legend.position = "bottom",
  legend.title.position = "top",
  legend.ncol = NULL,
  legend.nrow = NULL,
  legend.icon.size = 4,
  legend.byrow = FALSE,
  legend.dot.border = TRUE,
  raster.dpi = 2048,
  dims = c(1, 2),
  font.size = 14,
  font.type = "sans",
  na.value = "grey75",
  plot_cell_borders = TRUE,
  border.size = 2,
  border.color = "black",
  border.density = 1,
  plot_marginal_distributions = FALSE,
  marginal.type = "density",
  marginal.size = 5,
  marginal.group = TRUE,
  plot.axes = FALSE,
  plot_density_contour = FALSE,
  contour.position = "bottom",
  contour.color = "grey90",
  contour.lineend = "butt",
  contour.linejoin = "round",
  contour_expand_axes = 0.25,
  plot.title.face = "bold",
  plot.subtitle.face = "plain",
  plot.caption.face = "italic",
  axis.title.face = "bold",
  axis.text.face = "plain",
  legend.title.face = "bold",
  legend.text.face = "plain"
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{reduction}{\strong{\code{\link[base]{character}}} | Reduction to use. Can be the canonical ones such as "umap", "pca", or any custom ones, such as "diffusion". If you are unsure about which reductions you have, use \code{Seurat::Reductions(sample)}. Defaults to "umap" if present or to the last computed reduction if the argument is not provided.}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata variable to group the output by. Has to be a character of factor column.}

\item{split.by}{\strong{\code{\link[base]{character}}} | Secondary metadata variable to further group (split) the output by. Has to be a character of factor column.}

\item{split.by.combined}{\strong{\code{\link[base]{logical}}} | Adds a combined view of the all the values before splitting them by \strong{\code{split.by}}. Think of this as a regular DimPlot added in front. This is set to \strong{\code{TRUE}} if \strong{\code{split.by}} is used in combination with \strong{\code{group.by}}.}

\item{colors.use}{\strong{\code{\link[SCpubr]{named_vector}}} | Named vector of valid color representations (either name of HEX codes) with as many named colors as unique values of group.by. If group.by is not provided, defaults to the unique values of \link[Seurat]{Idents}. If not provided, a color scale will be set by default.}

\item{colorblind}{\strong{\code{\link[base]{logical}}} | Whether to use colorblind-friendly colors for categorical variables. In place when \code{colors.use} is not used. Allows for a maximum of 85 different classes within a categorical variable.}

\item{shuffle}{\strong{\code{\link[base]{logical}}} | Whether to shuffle the cells or not, so that they are not plotted cluster-wise. Recommended.}

\item{order}{\strong{\code{\link[base]{character}}} | Vector of identities to be plotted. Either one with all identities or just some, which will be plotted last.}

\item{raster}{\strong{\code{\link[base]{logical}}} | Whether to raster the resulting plot. This is recommendable if plotting a lot of cells.}

\item{pt.size}{\strong{\code{\link[base]{numeric}}} | Size of the dots.}

\item{label}{\strong{\code{\link[base]{logical}}} | Whether to plot the cluster labels in the UMAP. The cluster labels will have the same color as the cluster colors.}

\item{label.color}{\strong{\code{\link[base]{character}}} | Color of the labels in the plot.}

\item{label.fill}{\strong{\code{\link[base]{character}}} | Color to fill the labels. Has to be a single color, that will be used for all labels. If \strong{\code{NULL}}, the colors of the clusters will be used instead.}

\item{label.size}{\strong{\code{\link[base]{numeric}}} | Size of the labels in the plot.}

\item{label.box}{\strong{\code{\link[base]{logical}}} | Whether to plot the plot labels as \strong{\code{\link[ggplot2]{geom_text}}} (FALSE) or \strong{\code{\link[ggplot2]{geom_label}}} (TRUE).}

\item{repel}{\strong{\code{\link[base]{logical}}} | Whether to repel the text labels.}

\item{cells.highlight, idents.highlight}{\strong{\code{\link[base]{character}}} | Vector of cells/identities to focus into. The identities have to much those in \code{Seurat::Idents(sample)} The rest of the cells will be grayed out. Both parameters can be used at the same time.}

\item{idents.keep}{\strong{\code{\link[base]{character}}} | Vector of identities to keep. This will effectively set the rest of the cells that do not match the identities provided to NA, therefore coloring them according to na.value parameter.}

\item{sizes.highlight}{\strong{\code{\link[base]{numeric}}} | Point size of highlighted cells using cells.highlight parameter.}

\item{ncol}{\strong{\code{\link[base]{numeric}}} | Number of columns used in the arrangement of the output plot using "split.by" parameter.}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{legend.title}{\strong{\code{\link[base]{character}}} | Title for the legend.}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{legend.title.position}{\strong{\code{\link[base]{character}}} | Position for the title of the legend. One of:
\itemize{
\item \emph{\code{top}}: Top of the legend.
\item \emph{\code{bottom}}: Bottom of the legend.
\item \emph{\code{left}}: Left of the legend.
\item \emph{\code{right}}: Right of the legend.
}}

\item{legend.ncol}{\strong{\code{\link[base]{numeric}}} | Number of columns in the legend.}

\item{legend.nrow}{\strong{\code{\link[base]{numeric}}} | Number of rows in the legend.}

\item{legend.icon.size}{\strong{\code{\link[base]{numeric}}} | Size of the icons in legend.}

\item{legend.byrow}{\strong{\code{\link[base]{logical}}} | Whether the legend is filled by row or not.}

\item{legend.dot.border}{\strong{\code{\link[base]{logical}}} | Adds a black border around the dots in the legend.}

\item{raster.dpi}{\strong{\code{\link[base]{numeric}}} | Pixel resolution for rasterized plots. Defaults to 1024. Only activates on Seurat versions higher or equal than 4.1.0.}

\item{dims}{\strong{\code{\link[base]{numeric}}} | Vector of 2 numerics indicating the dimensions to plot out of the selected reduction. Defaults to c(1, 2) if not specified.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{na.value}{\strong{\code{\link[base]{character}}} | Color value for NA.}

\item{plot_cell_borders}{\strong{\code{\link[base]{logical}}} | Whether to plot border around cells.}

\item{border.size}{\strong{\code{\link[base]{numeric}}} | Width of the border of the cells.}

\item{border.color}{\strong{\code{\link[base]{character}}} | Color for the border of the heatmap body.}

\item{border.density}{\strong{\code{\link[base]{numeric}}} | Controls the number of cells used when \strong{\code{plot_cell_borders = TRUE}}. Value between 0 and 1. It computes a 2D kernel density and based on this cells that have a density below the specified quantile will be used to generate the cluster contour. The lower this number, the less cells will be selected, thus reducing the overall size of the plot but also potentially preventing all the contours to be properly drawn.}

\item{plot_marginal_distributions}{\strong{\code{\link[base]{logical}}} |  Whether to plot marginal distributions on the figure or not.}

\item{marginal.type}{\strong{\code{\link[base]{character}}} | One of:
\itemize{
\item \emph{\code{density}}: Compute density plots on the margins.
\item \emph{\code{histogram}}: Compute histograms on the margins.
\item \emph{\code{boxplot}}: Compute boxplot on the margins.
\item \emph{\code{violin}}: Compute violin plots on the margins.
\item \emph{\code{densigram}}: Compute densigram plots on the margins.
}}

\item{marginal.size}{\strong{\code{\link[base]{numeric}}} | Size ratio between the main and marginal plots. A value of 5 means that the main plot is 5 times bigger than the marginal plots.}

\item{marginal.group}{\strong{\code{\link[base]{logical}}} | Whether to group the marginal distribution by group.by or current identities.}

\item{plot.axes}{\strong{\code{\link[base]{logical}}} | Whether to plot axes or not.}

\item{plot_density_contour}{\strong{\code{\link[base]{logical}}} | Whether to plot density contours in the UMAP.}

\item{contour.position}{\strong{\code{\link[base]{character}}} | Whether to plot density contours on top or at the bottom of the visualization layers, thus overlapping the clusters/cells or not.}

\item{contour.color}{\strong{\code{\link[base]{character}}} | Color of the density lines.}

\item{contour.lineend}{\strong{\code{\link[base]{character}}} | Line end style (round, butt, square).}

\item{contour.linejoin}{\strong{\code{\link[base]{character}}} | Line join style (round, mitre, bevel).}

\item{contour_expand_axes}{\strong{\code{\link[base]{numeric}}} | To make the contours fit the plot, the limits of the X and Y axis are expanding a given percentage from the min and max values for each axis. This controls such percentage.}

\item{plot.title.face, plot.subtitle.face, plot.caption.face, axis.title.face, axis.text.face, legend.title.face, legend.text.face}{\strong{\code{\link[base]{character}}} | Controls the style of the font for the corresponding theme element.  One of:
\itemize{
\item \emph{\code{plain}}: For normal text.
\item \emph{\code{italic}}: For text in itallic.
\item \emph{\code{bold}}: For text in bold.
\item \emph{\code{bold.italic}}: For text both in itallic and bold.
}}
}
\value{
A ggplot2 object containing a DimPlot.
}
\description{
Wrapper for \link[Seurat]{DimPlot}.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_DimPlot", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Basic DimPlot.
    p <- SCpubr::do_DimPlot(sample = sample)


    # Restrict the amount of identities displayed.
    p <- SCpubr::do_DimPlot(sample = sample,
                            idents.keep = c("1", "3", "5"))

    # Group by another variable rather than `Seurat::Idents(sample)`
    p <- SCpubr::do_DimPlot(sample = sample,
                            group.by = "seurat_clusters")

    # Split the output in as many plots as unique identities.
    p <- SCpubr::do_DimPlot(sample = sample,
                            split.by = "seurat_clusters")

    # Highlight given identities
    p <- SCpubr::do_DimPlot(sample,
                            idents.highlight = c("1", "3"))

  } else if (base::isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}



}
