% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPECK.R
\name{speck}
\alias{speck}
\title{Abundance estimation for single cell RNA-sequencing (scRNA-seq) data.}
\usage{
speck(
  counts.matrix,
  rank.range.end = 100,
  min.consec.diff = 0.01,
  rep.consec.diff = 2,
  manual.rank = NULL,
  max.num.clusters = 4,
  seed.rsvd = 1,
  seed.ckmeans = 2
)
}
\arguments{
\item{counts.matrix}{\eqn{m x n} scRNA-seq counts matrix with \eqn{m} samples
and \eqn{n} genes.}

\item{rank.range.end}{Upper value of the rank for RRR.}

\item{min.consec.diff}{Minimum difference in the rate of change between a pair of successive standard deviation estimate.}

\item{rep.consec.diff}{Frequency of the minimum difference in the rate of change between a pair of successive standard deviation estimate.}

\item{manual.rank}{Optional, user-specified upper value of the rank used
for RRR as an alternative to automatically computed rank.}

\item{max.num.clusters}{Maximum number of clusters for computation.}

\item{seed.rsvd}{Seed specified to ensure reproducibility of the RRR.}

\item{seed.ckmeans}{Seed specified to ensure reproducibility of the clustered thresholding.}
}
\value{
\itemize{
  \item thresholded.mat - A \eqn{m x n} thresholded RRR matrix with \eqn{m} samples and \eqn{n} genes.
  \item rrr.mat - A \eqn{m x n} RRR matrix with \eqn{m} samples and \eqn{n} genes.
  \item rrr.rank - Automatically computed rank.
  \item component.stdev - A vector corresponding to standard deviations of non-centered sample principal components.
  \item clust.num - A vector of length \eqn{n} indicating the number of clusters identified by the
  \code{\link[Ckmeans.1d.dp:Ckmeans.1d.dp]{Ckmeans.1d.dp::Ckmeans.1d.dp()}} algorithm for each gene.
  \item clust.max.prop - A vector of length \eqn{n} indicating the proportion of samples with the
  specified maximum number of clusters for each gene.
}
}
\description{
Performs normalization, reduced rank reconstruction (RRR) and thresholding for a \eqn{m x n} scRNA-seq matrix
with \eqn{m} samples and \eqn{n} genes. The \code{\link[=speck]{speck()}} function calls the
\code{\link[=randomizedRRR]{randomizedRRR()}} function on the scRNA-seq matrix. Thresholding is next
applied to each gene from the \eqn{m x n} RRR matrix using the \code{\link[=ckmeansThreshold]{ckmeansThreshold()}}
function, resulting in a \eqn{m x n} thresholded matrix. See documentation for the \code{\link[=randomizedRRR]{randomizedRRR()}} and
\code{\link[=ckmeansThreshold]{ckmeansThreshold()}} functions for individual implementation details.
}
\examples{
set.seed(10)
data.mat <- matrix(data = rbinom(n = 18400, size = 230, prob = 0.01), nrow = 80)
speck.full <- speck(counts.matrix = data.mat, rank.range.end = 60,
min.consec.diff = 0.01, rep.consec.diff = 2,
manual.rank = NULL, max.num.clusters = 4,
seed.rsvd = 1, seed.ckmeans = 2)
print(speck.full$component.stdev)
print(speck.full$rrr.rank)
head(speck.full$clust.num); table(speck.full$clust.num)
head(speck.full$clust.max.prop); table(speck.full$clust.max.prop)
speck.output <- speck.full$thresholded.mat
dim(speck.output); str(speck.output)

}
