#' EV purchasing
#'
#' Details of people regarding the purchase of an EV.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 4 rows (corresponding to the 4 cells in a $2$ times $2$ table) and three columns:
#' \describe{
#'   \item{Education}{The level of education; one of \code{1} ('no post-graduate study') or \code{2} (post-graduate study')}
#'   \item{PurchaseEV}{Whether respondent would purchase an electric vehicle in the next 10 years'; one of \code{1} (Yes) or \code{2} (No)}
#'   \item{Counts}{The number of respondents in the given cell}
#' }
#' @source 
#' Egbue, Ona and Long, Suzanna (2012).
#' Barriers to widespread adoption of electric vehicles: 
#' An analysis of consumer attitudes and perceptions.
#' \emph{Energy Policy}, \bold{48}, 717--729.
#' 
#' @usage 
#' data(EVpurchase)
#' 
#' @examples
#' barplot( xtabs(Counts ~ PurchaseEV + Education, data = EVpurchase), 
#'          names.arg = c("No PG study", "PG study"), 
#'          ylab = "Number respondents")
#' 

"EVpurchase"
