% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fruit.R
\docType{data}
\name{Fruit}
\alias{Fruit}
\title{Fruit statistics from farms}
\format{
A data frame with 37 rows (one per farm) and 11 columns:
\describe{
  \item{Farm}{The farm identifier}
  \item{Flowers2014}{The number of flowers in 2014}
  \item{Flowers2015}{The number of flowers in 2015}
  \item{Fruit2014}{The total number of fruits formed in 2014}
  \item{Fruit2015}{The total number of fruits formed in 2015}
  \item{FLength2014}{The fruit length (in cm) in 2014}
  \item{FLength2015}{The fruit length (in cm) in 2015}
  \item{FBreadth2014}{The fruit breadth (in cm) in 2014}
  \item{FBreadth2015}{The fruit breadth (in cm) in 2015}
  \item{FWeight2014}{The fruit weight (in g) in 2014}
  \item{FWeight2015}{The fruit weight (in g) in 2015}
}
}
\source{
Ronita Mukherjee, Rittik Deb and Soubadra Devy (2020).
Diversity matters: effects of density compensation in 
pollination service during rainfall shift [Dataset]. 
Dryad. 
https://doi.org/10.5061/dryad.0n5v168
}
\usage{
data(Fruit)
}
\description{
Details of fruit from different farms.
}
\examples{
with(Fruit, hist(Flowers2015 - Flowers2014, 
     xlab = "Increase in flowers to 2015", 
     ylab = "Number of farms") )

}
\references{
Mukherjee, Ronita; Deb, Rittik; Devy, Soubadra (2020). 
Diversity matters: Effects of density compensation in 
pollination service during rainfall shift
\emph{Ecology and Evolution}, \bold{9}(17), 9701--9711.
}
\keyword{datasets}
