% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IgE.R
\docType{data}
\name{IgE}
\alias{IgE}
\title{IgE concentrations}
\format{
A data frame with 11 rows (one per child) and 3 columns:
\describe{
  \item{Before}{IgE (before intervention), in micrograms/L}
  \item{After}{IgE (after intervention), in micrograms/L}
  \item{Reduction}{The reduction in IgE, in micrograms/L}
}
}
\source{
Lothian, James B. and Grey, Vijaylaxmi  and Lands, Larry C.  (2006).
"Effect of whey protein to modulate immune response in children 
with atopic asthma",
\emph{International Journal of Food Science and Nutrition},
\bold{57} (3/4), 204--211.
}
\usage{
data(IgE)
}
\description{
IgE concentration before and after intervention.
}
\examples{
with(IgE, hist( After - Before) )

}
\keyword{datasets}
