% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coinertia.partial.syncsa.R,
%   R/coinertia.syncsa.R
\encoding{UTF-8}
\name{coinertia.partial.syncsa}
\alias{coinertia.partial.syncsa}
\alias{coinertia.syncsa}
\title{Co-inertia and Partial Co-inertia correlations.}
\usage{
coinertia.partial.syncsa(x, y, z, scale = FALSE)

coinertia.syncsa(x, y, scale = FALSE)
}
\arguments{
\item{x, y}{Matrix that will be correlated.}

\item{z}{Matrix whose effect will be removed from the correlation between x and y.}

\item{scale}{Standardized variables to unit variance.}
}
\value{
RV coefficient (generalization of the Pearson correlation coefficient) between matrices.
}
\description{
Function to obtain the RV coefficient between two matrices and
partial RV coefficient between three matrices.
}
\references{
Legendre, P. and Legendre L. (2012). Numerical Ecology. 3nd English edition. Elsevier.
}
\seealso{
\code{\link{syncsa}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{SYNCSA}
