
##########################################################################################################################################

test_that("checksharpSVbound works for correct input.", {
  expect_equal(checksharpSVbound(whichEst = "RR_sub", BF = c(1.56, 2), pY1 = c(0.33, 0.1))[[1]], "The lower SV bound for the risk ratio in the subpopulation is sharp.")
  expect_equal(checksharpSVbound(whichEst = "RR_sub", BF = c(10, 10), pY1 = c(0.8, 0.8))[[1]], "The lower SV bound for the risk ratio in the subpopulation is not sharp.")
})


##########################################################################################################################################

test_that("checksharpSVbound throws an error for incorrect input.", {
  expect_error(checksharpSVbound(whichEst = "RR_t", BF = c(1, 1), pY1 = c(0.8, 0.8)), 'The estimand must be')
  expect_error(checksharpSVbound(whichEst = "RR_tot", BF = c(0.5, 1), pY1 = c(0.8, 0.8)), "greater than or equal to 1")
  expect_error(checksharpSVbound(whichEst = "RR_tot", BF = c(1, 1), pY1 = c(2, 0.8)), "not between 0 and 1")
  expect_error(checksharpSVbound(whichEst = "RR_tot", BF = c(1, 1), pY1 = c(-1, 0.8)), "not between 0 and 1")
})

##########################################################################################################################################

