% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verhulst.R
\docType{data}
\name{verhulst}
\alias{verhulst}
\title{Verhulst-Pearl model}
\usage{
verhulst(
  n_0 = 10000,
  K = 10000,
  r = 0.9,
  sigma = 0.4,
  tau = 0.1,
  dt = 0.01,
  seed = 73658676L
)
}
\arguments{
\item{n_0}{initial condition}

\item{K}{carrying capacity}

\item{r}{intrinsic growth rate}

\item{sigma}{environmental process noise s.d.}

\item{tau}{measurement error s.d.}

\item{dt}{Euler timestep}

\item{seed}{seed of the random number generator}
}
\value{
A \sQuote{pomp} object containing the model and simulated data.
The following basic components are included in the \sQuote{pomp} object:
\sQuote{rinit}, \sQuote{rprocess}, \sQuote{rmeasure}, \sQuote{dmeasure}, and \sQuote{skeleton}.
}
\description{
The Verhulst-Pearl (logistic) model of population growth.
}
\details{
A stochastic version of the Verhulst-Pearl logistic model.
This evolves in continuous time, according to the stochastic differential equation
\deqn{dn_t = r\,n_t\,\left(1-\frac{n_t}{K}\right)\,dt+\sigma\,n_t\,dW_t.}{dn[t] = r n[t] (1-n[t]/K) dt + sigma n[t] dW[t].}

Numerically, we simulate the stochastic dynamics using an Euler approximation.

The measurements are assumed to be log-normally distributed:
\deqn{N_t \sim \mathrm{Lognormal}\left(\log{n_t},\tau\right).}{N[t] ~ Lognormal(log(n[t]),tau).}
}
\examples{
\donttest{ # takes too long for R CMD check
  verhulst() -> po
  plot(po)
  plot(simulate(po))
  pfilter(po,Np=1000) -> pf
  logLik(pf)
  spy(po)
}
}
\seealso{
More examples provided with \pkg{pomp}: 
\code{\link{blowflies}},
\code{\link{childhood_disease_data}},
\code{\link{compartmental_models}},
\code{\link{dacca}()},
\code{\link{ebola}},
\code{\link{gompertz}()},
\code{\link{ou2}()},
\code{\link{pomp_examples}},
\code{\link{ricker}()},
\code{\link{rw2}()}
}
\concept{pomp examples}
