% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.software.R
\name{clean.software}
\alias{clean.software}
\title{Clean TAF Software}
\usage{
clean.software(folder = "boot/software", quiet = FALSE, force = FALSE)
}
\arguments{
\item{folder}{location of local TAF software folder.}

\item{quiet}{whether to suppress messages about removed software.}

\item{force}{whether to remove the local TAF software folder, regardless of
how it compares to \verb{SOFTWARE.bib} entries.}
}
\value{
No return value, called for side effects.
}
\description{
Selectively remove software from the local TAF software folder if not listed
in \verb{SOFTWARE.bib}.
}
\note{
For each file (and subdirectory) in the software folder, the cleaning
procedure selects between three cases:
\enumerate{
\item File and version matches \verb{SOFTWARE.bib} - do nothing.
\item Filename does not contain the version listed in \verb{SOFTWARE.bib} -
      remove.
\item File is not listed in \verb{SOFTWARE.bib} - remove.
}

The \code{taf.boot} procedure cleans the TAF software folder, without
requiring the user to run \code{clean.software}. The main reason for a TAF
user to run \code{clean.software} directly is to experiment with installing
and removing different versions of software without modifying the
\verb{SOFTWARE.bib} file.
}
\examples{
\dontrun{
clean.software()
}

}
\seealso{
\code{\link{taf.boot}} calls \code{clean.software} as part of the default
boot procedure.

\code{\link{download.github}} downloads a GitHub repository.

\code{\link{clean.library}} cleans the local TAF library.

\code{\link{clean.data}} cleans the \verb{boot/data} folder.

\code{\link{TAF-package}} gives an overview of the package.
}
