% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPDDev.R
\name{TPDDev}
\alias{TPDDev}
\title{Two-Phase Experimental Design Development}
\usage{
TPDDev(d1, base_d2)
}
\arguments{
\item{d1}{Numeric matrix. Phase-I layout (rows = blocks, columns = plots per block).}

\item{base_d2}{Numeric matrix. Base Phase-II layout (rows = blocks, columns = plots per block).}
}
\value{
A list containing design parameters, combined two-phase design layout,
        information matrices, and efficiency factor.
}
\description{
`TPDDev()` constructs a two-phase experimental design layout,
computes the information matrices for residual, direct, and interaction effects,
and calculates the efficiency factor.
}
\details{
Steps performed:
\enumerate{
  \item Checks that `ncol(d1)` equals `nrow(base_d2)`.
  \item Expands the Phase-II layout for each Phase-I block.
  \item Builds the combined layout and treatment-incidence matrices.
  \item Computes block-incidence matrix and overall mean matrix.
  \item Derives overall C-matrix for factorial treatment effects.
  \item Projects C-matrix to obtain residual, direct, and interaction effect matrices.
  \item Calculates the efficiency factor of the design.
}
}
\examples{
d1 <- matrix(c(
  1,2,3,4,5,6,7,
  2,3,4,5,6,7,8,
  3,4,5,6,7,8,1,
  4,5,6,7,8,1,2,
  5,6,7,8,1,2,3,
  6,7,8,1,2,3,4,
  7,8,1,2,3,4,5,
  8,1,2,3,4,5,6
), nrow = 8, byrow = TRUE)

base_d2 <- matrix(c(
  1,2,4,
  2,3,5,
  3,4,6,
  4,5,7,
  5,6,1,
  6,7,2,
  7,1,3
), ncol = 3, byrow = TRUE)

result <- TPDDev(d1, base_d2)
result$efficiency_factor
result$C_dir

}
