% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waic.R
\name{waic.tridim_transformation}
\alias{waic.tridim_transformation}
\title{Computes widely applicable information criterion
(WAIC).}
\usage{
\method{waic}{tridim_transformation}(x, ...)
}
\arguments{
\item{x}{A [tridim_transformation[\code{\link[=tridim_transformation-class]{tridim_transformation-class()}} object}

\item{...}{unused}
}
\value{
A named list, see \code{\link[loo:waic]{loo::waic()}} for details.
}
\description{
Computes widely applicable information criterion
via \link[loo:loo-package]{loo} library. It can be used for a model comparison via
\link[loo:loo_compare]{loo::loo_compare()} function.
}
\examples{
euc2 <- fit_transformation(depV1+depV2~indepV1+indepV2,
  NakayaData, transformation = 'euclidean')
aff2 <- fit_transformation(depV1+depV2~indepV1+indepV2,
  NakayaData, transformation = 'affine')
loo::loo_compare(waic(euc2), waic(aff2))
}
