% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UBStats_Main_Visible_ALL_202508.R
\name{distr.table.x}
\alias{distr.table.x}
\title{Analysis of a univariate distribution using frequency tables}
\usage{
distr.table.x(
  x,
  freq = c("counts", "proportions"),
  total = TRUE,
  breaks,
  adj.breaks = TRUE,
  interval = FALSE,
  f.digits = 2,
  p.digits = 0,
  d.digits = 5,
  force.digits = FALSE,
  use.scientific = FALSE,
  data,
  ...
)
}
\arguments{
\item{x}{An unquoted string identifying the variable whose
distribution has to be analysed. \code{x} can be the name of a vector
or a factor in the workspace or the name of one of the columns in the
data frame specified in the \code{data} argument.}

\item{freq}{A character vector specifying the set of frequencies to be
displayed (more options are allowed). Allowed options (possibly abbreviated)
are \code{"counts"}, \code{"percentages"}, \code{"proportions"},
\code{"densities"} (only for variables classified into intervals
or measured in classes), and \code{"cumulative"}.
If no frequency is specified, \code{"counts"}
and \code{"proportions"} are displayed by default.
If only \code{"cumulative"} is specified, counts and proportions
are displayed too, with their respective cumulative frequencies.}

\item{total}{Logical value indicating whether the sum of the requested
frequencies should be added to the table; default to \code{TRUE}.}

\item{breaks}{Allows to classify a \emph{numerical} variable \code{x} into
intervals. It can be an integer indicating the number of intervals of
equal width used to classify \code{x}, or a vector of increasing numeric
values defining the endpoints of intervals (closed on the left and open
on the right; the last interval is closed on the right too). To cover
the entire range of values the maximum and the minimum values should be
included between the first and the last break. It is possible to specify
a set of breaks covering only a portion of the \code{x} range.}

\item{adj.breaks}{Logical value indicating whether the endpoints of
intervals of a numerical variable \code{x} when classified
into intervals should be displayed avoiding scientific notation;
default to \code{TRUE}.}

\item{interval}{Logical value indicating whether \code{x} is a variable
measured in intervals (\code{TRUE}). If the detected intervals are not
consistent (e.g. overlapping intervals, or intervals with upper endpoint
higher than the lower one), the variable is tabulated as it is, even if
results are not necessarily consistent; default to \code{FALSE}.}

\item{f.digits, p.digits, d.digits}{Integer values specifying the number of
decimals used to round respectively proportions (default: \code{f.digits=2}),
percentages (default: \code{p.digits=0}), and densities
(default: \code{d.digits=5}). If the chosen rounding formats some
non-zero values as zero, the number of decimals is increased
so that all values have at least one significant digit, unless the argument
\code{force.digits} is set to \code{TRUE}.}

\item{force.digits}{Logical value indicating whether frequencies and
densities should be forcedly rounded to the number of decimals specified in
\code{f.digits}, \code{p.digits}, and \code{d.digits} even if non-zero
values are rounded to zero (default to \code{FALSE}).}

\item{use.scientific}{Logical value indicating whether numbers
in tables (typically densities) should be displayed using
scientific notation (\code{TRUE}); default to \code{FALSE}.}

\item{data}{An optional data frame containing \code{x}.
If not found in \code{data}, \code{x} is taken from the environment
from which \code{distr.table.x()} is called.}

\item{...}{Additional arguments to be passed to low level functions.}
}
\value{
A table (converted to dataframe) listing the
values taken by the variable, arranged in standard
order (logical, alphabetical or numerical order for vectors,
order of levels for factors, ordered intervals for classified
variables or for variables measured in classes), and the requested set
of frequencies.
}
\description{
\code{distr.table.x()} computes the frequency table of a vector or a factor.
}
\examples{
data(MktDATA, package = "UBStats")

# Character vectors, factors, and discrete numeric vectors
distr.table.x(Education, data = MktDATA)

distr.table.x(Children, freq = c("count","prop","cum"),
              data = MktDATA)

# Numerical variable classified into intervals
# - Classes of equal width
distr.table.x(AOV, breaks = 6, freq = c("Count","Prop","Perc","Cum"),
              p.digits = 2, data = MktDATA)
# - Classes with specified endpoints
distr.table.x(AOV, breaks = c(0,20,30,50,100,180),
              freq = c("Count","Perc","Cum","Densities"), 
              p.digits = 2, data = MktDATA)
# Numerical variable measured in classes
# - Variable measured in classes
distr.table.x(Income, freq = c("count","prop","cum","dens"),
              interval = TRUE, data = MktDATA)
# - An example of non-consistent intervals. 
#   Densities are not calculated
x.inconsistent <- c(rep("0;10",30),rep("10;20",25),rep("25;8",25),
                    rep("15;31",15),rep("20;45",16),rep("30;40",18))
distr.table.x(x.inconsistent, freq = c("count","prop","cum","dens"),
              interval = TRUE)

# Arguments adj.breaks, use.scientific, and force.digits
#  A variable with a very wide range (very small densities)
LargeX <- MktDATA$AOV*5000000 
# - Default: manages possible excess of rounding
distr.table.x(LargeX, breaks = 5, 
              freq = c("count","percent","densities"))
# - Forcing digits to the default values 
distr.table.x(LargeX, breaks = 5,
              freq=c("count","percent","dens"),
              force.digits = TRUE)
#  - Scientific notation for frequencies/densities 
distr.table.x(LargeX, breaks = 5,
              freq = c("count","percent","dens"),
              use.scientific = TRUE)
#  - Scientific notation both for intervals’ endpoints 
#    and for frequencies/densities
distr.table.x(LargeX, breaks = 5, adj.breaks = FALSE,
              freq = c("count","percent","dens"),
              use.scientific = TRUE)

# Output a dataframe with the table
table.AOV<-distr.table.x(AOV, breaks = c(0,20,30,50,100,180),
                         freq = c("Count","Perc","Cum","Dens"), 
                         data = MktDATA)
                         
}
\seealso{
\code{\link{distr.plot.x}()} for plotting a univariate
distribution.

\code{\link{distr.table.xy}()} for tabulating a bivariate
distribution.

\code{\link{distr.plot.xy}()} for plotting a bivariate
distribution.
}
\author{
Raffaella Piccarreta \email{raffaella.piccarreta@unibocconi.it}
}
