% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonal_uvb.R
\name{season_uvb}
\alias{season_uvb}
\title{Seasonal UVB}
\usage{
season_uvb(
  data,
  date,
  longitude,
  latitude,
  temis_path = getwd(),
  season = "summer",
  type = "cumulative",
  region = "europe"
)
}
\arguments{
\item{data}{data frame containing sample IDs, date, longitude, and latitude}

\item{date}{A date vector, usually date of assessment or recruitment.}

\item{longitude}{A numeric vector of longitude values.}

\item{latitude}{A numeric vector of latitude values.}

\item{temis_path}{Path to TEMIS UV files downloaded using \link{temis_uvdvc}. Default is current directory.}

\item{season}{The duration over which erythemal UV dose is to be estimated. One of "summer" covering April to September (default), "winter" covering October to March, or a numeric vector corresponding to month range.}

\item{type}{Type of annual dose to be calculated, cumulative (default) or mean.}

\item{region}{Region of TEMIS data required, options are "europe" (default) or "world".}
}
\value{
A numeric vector of mean or cumulative seasonal UVB dose estimates.
}
\description{
This function estimates mean or cumulative vitamin D-effective UVB dose over a period of months (<1 year) prior to the index date, at a given geographical location (longitude and latitude).
}
\examples{
#uses sample TEMIS file
mysample <- data.frame(id = c("id000016"),
        date = as.Date(c("2010-08-04")),
        longitude = c(-2.10),
        latitude = c(50.5))
uvb_example <- system.file("extdata", "uvb_example", package="UVdose")
season_uvb(mysample, date, longitude, latitude, temis_path=uvb_example,  season = "winter")

season_uvb(mysample, date, longitude, latitude, temis_path=uvb_example, season = c(6:8))

}
