% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Adaplotfnc.R
\name{adaplot}
\alias{adaplot}
\title{Creates Ada-plot for the provided data.}
\usage{
adaplot(X, title = "Ada-plot", xlab = "x", lcol = "black", rcol = "grey60", ...)
}
\arguments{
\item{X}{an \eqn{n} by \eqn{1} matrix, equivalently, a column vector of length \eqn{n}, where \eqn{n} is the number of observations.}

\item{title}{title of the plot, \emph{Ada-plot} by default.}

\item{xlab}{\eqn{x}-axis label, \eqn{x} by default.}

\item{lcol}{color of the points which correspond to data on or below the sample average, \emph{black} by default.}

\item{rcol}{color of the points which correspond to data above the sample average, \emph{grey60} by default.}

\item{...}{other graphical parameters.}
}
\value{
Ada-plot
}
\description{
Ada-plot identifies the characteristics of the distribution such as symmetry, skewness, and outliers of the data set.
}
\examples{
   set.seed(0)
   X1 <- matrix(rnorm(50, mean = 2, sd = 5))
   adaplot(X1)

   X2 <- matrix(rf(50, df1 = 10, df2 = 5))
   adaplot(X2)

   X3 <- matrix(rbeta(50, shape1 = 10, shape2 = 2))
   adaplot(X3, title = "", lcol = "blue", rcol = "red")
}
\references{
Wijesuriya, U. A. (2025a). Ada-plot and Uda-plot as Alternatives for
            Ad-plot and Ud-plot.
            \emph{Communications in Statistics-Theory and Methods}, \doi{10.1080/03610926.2025.2558108}.

Wijesuriya, U. A. (2025b). Ad-plot and Ud-plot for Determining Distributional Characteristics
            and Normality.
            \emph{Communications in Statistics-Theory and Methods}, \doi{10.1080/03610926.2024.2440583}.

Wijesuriya, U. A. (2025c). adplots: Ad-plot and Ud-plot for Visualizing Distributional
            Properties and Normality.
            \emph{R Package Version 0.1.0}, \doi{10.32614/CRAN.package.adplots}.
}
