% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDesign.R
\name{check_design_met}
\alias{check_design_met}
\title{Check Experimental Design}
\usage{
check_design_met(
  data = NULL,
  genotype = NULL,
  trial = NULL,
  traits = NULL,
  rep = NULL,
  block = NULL,
  row = NULL,
  col = NULL
)
}
\arguments{
\item{data}{A data.frame in a wide format.}

\item{genotype}{A character string indicating the column in data that
contains genotypes.}

\item{trial}{A character string indicating the column in data that contains
trials.}

\item{traits}{A character vector specifying the traits for which the models
should be fitted.}

\item{rep}{A character string indicating the column in data that contains
replicates.}

\item{block}{A character string indicating the column in data that contains
sub blocks.}

\item{row}{A character string indicating the column in data that contains the
row coordinates.}

\item{col}{A character string indicating the column in data that contains the
column coordinates.}
}
\value{
An object of class \code{checkAgri}, with a list of:
\item{summ_traits}{A data.frame containing a summary of the traits.}
\item{exp_design_resum}{A data.frame containing a summary of the experimental
 design.}
\item{filter}{A list by trait containing the filtered trials.}
\item{exp_design_list}{A data.frame containing the experimental design of
each trial.}
\item{check_connectivity}{A data.frame with the genotype connectivity.}
\item{connectivity_matrix}{A matrix with the amount of genotypes shared
between each pair of trial.}
\item{data_design}{A data frame containing the data used with two additional
columns, one realted to the experimental design and a sequential number (id)}
\item{inputs}{A list containing the character string that indicates the
column in data that contains the genotype, trial, traits, rep, block, row
and col.}
}
\description{
This function helps to identify the experimental design of each
trial, filters the data and then provide a summary for the traits and the
experimental design. This works as a quality check before we fit any model.
Returns an object of class \code{checkAgri}.
}
\examples{
library(agridat)
library(agriutilities)
data(besag.met)
dat <- besag.met
results <- check_design_met(
  data = dat,
  genotype = "gen",
  trial = "county",
  traits = c("yield"),
  rep = "rep",
  block = "block",
  col = "col",
  row = "row"
)
print(results)
plot(results, type = "connectivity")
plot(results, type = "missing")
}
