% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordPredRandom.R
\name{ordPredRandom}
\alias{ordPredRandom}
\title{Randomized Mapping from an Estimated Probability Distribution (EPD) to a Predicted Class}
\usage{
ordPredRandom(P, z = NULL, tol = 1e-12)
}
\arguments{
\item{P}{A numeric matrix of size \eqn{n \times k}, where each row contains
the estimated probabilities \eqn{\hat\pi_{ij}} for subject \eqn{i} and
classes \eqn{j = 1,\ldots,k}. Values must be nonnegative; rows are
normalized to sum to one if needed.}

\item{z}{Optional numeric vector of length \eqn{n} with values in \eqn{(0,1]}
providing external uniforms for reproducibility or control. If \code{NULL}
(default), draws are generated internally via \code{runif(n)}.}

\item{tol}{Numeric tolerance used for row-sum checks and for guarding against
underflow when normalizing. Defaults to \code{1e-12}.}
}
\value{
An integer vector of length \eqn{n} with the predicted class indices
  in \eqn{\{1,\ldots,k\}} for each row of \code{P}.
}
\description{
Stochastically maps each row of an estimated probability distribution (EPD)
matrix to a single predicted class by drawing one sample from the row's
categorical distribution. Rows are normalized to sum to one (within tolerance),
and the cut-points method is used with intervals \eqn{(c_{i,j-1}, c_{i,j}]},
ensuring \eqn{z_i=1} maps to class \eqn{k}.
}
\details{
The mapping follows the cumulative cut-points
\eqn{c_{i,0}=0}, \eqn{c_{i,j}=\sum_{\ell=1}^j \hat\pi_{i\ell}} for
\eqn{j=1,\ldots,k}, and assigns class \eqn{j} whenever
\eqn{c_{i,j-1} < z_i \le c_{i,j}}. When \code{z} is supplied, values are
clipped to \eqn{(0,1]} to respect interval boundaries. Rows with (near) zero
total probability trigger an error.
}
\examples{
set.seed(1)
P <- rbind(
  c(0.05, 0.10, 0.25, 0.60),
  c(0.40, 0.40, 0.10, 0.10),
  c(0.00, 0.20, 0.80, 0.00)
)

# Stochastic draws from each row's EPD
ordPredRandom(P)

# Reproducible draws using provided uniforms
z <- c(0.2, 0.85, 1.0)
ordPredRandom(P, z = z)

}
\seealso{
\code{\link[apor:nopa]{nopa}},
\code{\link[apor:ordPredArgmax]{ordPredArgmax}}
\code{\link[apor:opdRef]{opdRef}}
}
