% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_compare_IUCN.R
\name{compare_IUCN}
\alias{compare_IUCN}
\title{Check EOO differences between two sets of coordinates}
\usage{
compare_IUCN(x, y, plots = TRUE, verbose = TRUE)
}
\arguments{
\item{x}{data.frame. With two columns containing latitude and longitude. Considered during reporting as data from a LLM.}

\item{y}{data.frame. With the same formatting as \code{x}. Considered during reporting as the ground truth.}

\item{plots}{logical. Determines if plots should be printed.}

\item{verbose}{logical. Determines if output should be printed.}
}
\value{
list with two values, the percentage of \code{y} that is part of the intersection with \code{x} and \code{y} and the percentage of \code{x} that is part of the intersection with \code{x} and \code{y}
}
\description{
Calculate EOO for two sets of coordinates for a practical assessment of data proximity.
}
\details{
Extent of occurrence (EOO) is defined as "the area contained within the shortest continuous imaginary boundary which can be drawn to encompass all the known, inferred or projected sites of present occurrence of a taxon, excluding cases of vagrancy"
}
\examples{
set_a = matrix(
  c(54.30379, -25.48098, 54.21251,	-25.47146, 59.53277, -20.37448, 55.59712,
 -22.39599, 55.47244, -26.30330, 61.39205,	-21.12364, 56.24010, -24.40347),
 ncol = 2, byrow = TRUE 
)

set_b = matrix(
c(54.30379,	-25.48098, 111.42100,	-19.00400, 54.21251, -25.47146, 59.53277,
  -20.37448, 55.59125, -22.39599, 55.47244,	-26.30330, 61.39205, -21.12364,
   56.24010,	-24.40347),
   ncol = 2, byrow = TRUE
 )

compare_IUCN(set_a, set_b)
}
