% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filesystem.R
\name{copy_files}
\alias{copy_files}
\title{Copy files between FileSystems}
\usage{
copy_files(from, to, chunk_size = 1024L * 1024L)
}
\arguments{
\item{from}{A string path to a local directory or file, a URI, or a
\code{SubTreeFileSystem}. Files will be copied recursively from this path.}

\item{to}{A string path to a local directory or file, a URI, or a
\code{SubTreeFileSystem}. Directories will be created as necessary}

\item{chunk_size}{The maximum size of block to read before flushing
to the destination file. A larger chunk_size will use more memory while
copying but may help accommodate high latency FileSystems.}
}
\value{
Nothing: called for side effects in the file system
}
\description{
Copy files between FileSystems
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
# Copy an S3 bucket's files to a local directory:
copy_files("s3://your-bucket-name", "local-directory")
# Using a FileSystem object
copy_files(s3_bucket("your-bucket-name"), "local-directory")
# Or go the other way, from local to S3
copy_files("local-directory", s3_bucket("your-bucket-name"))
\dontshow{\}) # examplesIf}
}
