% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_output.R
\name{save_output}
\alias{save_output}
\alias{save_output.autoslider_error}
\alias{save_output,dVTableTree-method}
\alias{save_output,}
\alias{dVTableTree,}
\alias{dVTableTree-method}
\alias{save_output.decoratedGrob}
\alias{save_output.decoratedGrobSet}
\alias{save_output.dgtsummary}
\alias{save_output.dlisting}
\title{Save an Output}
\usage{
save_output(output, file_name, save_rds = TRUE)

save_output(output, file_name, save_rds = TRUE)

save_output.autoslider_error(output, file_name, save_rds = TRUE)

\S4method{save_output}{dVTableTree}(output, file_name, save_rds = TRUE)

save_output.decoratedGrob(output, file_name, save_rds = TRUE)

save_output.decoratedGrobSet(output, file_name, save_rds = TRUE)

save_output.dgtsummary(output, file_name, save_rds = TRUE)

save_output.dlisting(output, file_name, save_rds = TRUE)
}
\arguments{
\item{output}{Output object, e.g. an `rtable` or `grob`}

\item{file_name}{Full path of the new file *excluding* the extension}

\item{save_rds}{Saved as an `.rds` files}
}
\value{
The input `object` invisibly

No return value, called for side effects

The input `object` invisibly

The input `object` invisibly

The input `object` invisibly

The input `object` invisibly
}
\description{
Save an Output
}
\details{
Tables are saved as RDS file
}
\examples{
library(dplyr)
adsl <- eg_adsl \%>\%
  filter(SAFFL == "Y") \%>\%
  mutate(TRT01P = factor(TRT01P, levels = c("A: Drug X", "B: Placebo")))
output_dir <- tempdir()
t_dm_slide(adsl, "TRT01P", c("SEX", "AGE", "RACE", "ETHNIC", "COUNTRY")) \%>\%
  decorate(
    title = "Demographic table",
    footnote = ""
  ) \%>\%
  save_output(
    file_name = file.path(output_dir, "t_dm_SE"),
    save_rds = TRUE
  )

}
