% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Teste_u.R
\name{teste.u}
\alias{teste.u}
\title{Teste de Mann-Whitney}
\usage{
teste.u(
  ...,
  titulo = "Teste de Mann-Whitney",
  x = "Grupo",
  y = "Valor",
  ajuda = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{...}{Dois vetores numericos independentes (ex: grupo1, grupo2).}

\item{titulo}{Titulo do grafico (string). Default: "Teste de Mann-Whitney".}

\item{x}{Nome do eixo x no grafico (string). Default: "Grupo".}

\item{y}{Nome do eixo y no grafico (string). Default: "Valor".}

\item{ajuda}{Logico. Se TRUE, exibe explicacao detalhada da funcao. Default: FALSE.}

\item{verbose}{Se TRUE, imprime mensagens detalhadas (default = TRUE)}
}
\value{
Lista invisivel com:
\describe{
\item{resumo}{Resumo estatistico (media e desvio padrao) por grupo}
\item{resultado}{Resultado do teste (objeto stats::htest)}
\item{grafico}{Objeto ggplot2 com visualizacao dos grupos}
}
}
\description{
Realiza o teste de Mann-Whitney para comparacao de dois grupos nao-parametricos,
apresentando resultado com interpretacao e grafico.
}
\examples{
x <- c(1, 3, 5, 6)
y <- c(7, 8, 9, 12)
teste.u(x, y)
}
