% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.ord_compute_ellipse.R
\name{ord_compute_ellipse}
\alias{ord_compute_ellipse}
\title{Compute coordinates for an ordination ellipse}
\usage{
ord_compute_ellipse(
  cov,
  center = c(0, 0),
  kind = "se",
  conf = 0.95,
  npoints = 100,
  n = NULL
)
}
\arguments{
\item{cov}{Numeric matrix (2x2) covariance matrix.}

\item{center}{Numeric vector of length 2 specifying the ellipse center coordinates.}

\item{kind}{Character string specifying the type of ellipse: either
\code{"se"} for standard error/confidence ellipse or \code{"sd"} for standard deviation dispersion ellipse.}

\item{conf}{Numeric confidence level or coverage (default 0.95).}

\item{npoints}{Integer number of points to generate along ellipse perimeter (default 100).}

\item{n}{Numeric sample size; \strong{required} if \code{kind = "se"}.}
}
\value{
A numeric matrix with two columns representing x and y coordinates of the ellipse.
}
\description{
Calculates ellipse coordinates based on a covariance matrix and center.
Supports confidence ellipses (standard error, "se") or dispersion ellipses ("sd").
}
\examples{
cov_mat <- matrix(c(1, 0, 0, 1), 2, 2)
center <- c(0, 0)
ell_coords <- ord_compute_ellipse(cov_mat, center, kind = "se", conf = 0.95, n = 10)
plot(ell_coords, type = "l")

}
