% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binbf01.R
\name{binbf01}
\alias{binbf01}
\title{Binomial Bayes factor}
\usage{
binbf01(
  x,
  n,
  p0 = 0.5,
  type = c("point", "direction"),
  a = 1,
  b = 1,
  log = FALSE
)
}
\arguments{
\item{x}{Number of successes}

\item{n}{Number of trials}

\item{p0}{Tested binomial proportion. Defaults to \code{0.5}}

\item{type}{Type of test. Can be \code{"point"} or \code{"directional"}.
Defaults to \code{"point"}}

\item{a}{Number of successes parameter of the beta prior distribution.
Defaults to \code{1}}

\item{b}{Number of failures parameter of the beta prior distribution.
Defaults to \code{1}}

\item{log}{Logical indicating whether the natural logarithm of the Bayes
factor should be returned. Defaults to \code{FALSE}}
}
\value{
Bayes factor in favor of the null hypothesis over the alternative
    (\eqn{\text{BF}_{01}}{BF01} > 1 indicates evidence for the null
    hypothesis, whereas \eqn{\text{BF}_{01}}{BF01} < 1 indicates evidence for
    the alternative)
}
\description{
This function computes the Bayes factor for testing a binomial
proportion \eqn{p} based on \eqn{x} observed successes out of \eqn{n}
trials. Two types of tests are available:
\itemize{
\item Test of a point null hypothesis: The Bayes factor quantifies the evidence
for \eqn{H_0 \colon p = p_0}{H0: p = p0} against \eqn{H_1 \colon p \neq
p_0}{H1: p != p0}. A beta prior is assigned to the proportion \eqn{p} under
the alternative hypothesis \eqn{H_1}{H1}.
\item Test of a directional null hypothesis: The Bayes factor quantifies the
evidence for \eqn{H_0 \colon p \leq p_0}{H0: p <= p0} against \eqn{H_1 \colon
p > p_0}{H1: p > p0}. A beta prior that is truncated to the range \eqn{[0,
p_0]}{[0, p0]} under the null \eqn{H_0}{H0} and to \eqn{(p_0, 1]}{(p0, 1]}
under the alternative \eqn{H_1}{H1} is assigned to the proportion \eqn{p}
under the corresponding hypothesis.
}
}
\examples{
## example on Mendelian inheritance from ?stats::binom.test
binbf01(x = 682, n = 925, p0 = 3/4, a = 1, b = 1, type = "point")
## 18.6 => strong evidence for the hypothesized p = 3/4 compared to other p

## with directional hypothesis
binbf01(x = 682, n = 925, p0 = 3/4, a = 1, b = 1, type = "direction")
## 1.5 => only anecdotal evidence for p <= 3/4 over p > 3/4

## Particle-counting experiment from Stone (1997) with point null
binbf01(x = 106298, n = 527135, p0 = 0.2, a = 1, b = 1, type = "point")
## 8.1 => moderate evidence for the alternative over the null

## Coin flip experiment from Bartos et al. (2023) with point null
binbf01(x = 178079, n = 350757 , p0 = 0.5, a = 5100, b = 4900, type = "point")
## => 1/1.72e+17 extreme evidence in favor of the alternative over the null

}
\seealso{
\link{pbinbf01}, \link{nbinbf01}
}
\author{
Samuel Pawel
}
