% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrate_to_ppi.R
\name{add_expected_eta_to_scan}
\alias{add_expected_eta_to_scan}
\title{Adds expected eta to a scan}
\usage{
add_expected_eta_to_scan(
  scan,
  vp,
  quantity = "dens",
  param = "DBZH",
  lat,
  lon,
  antenna,
  beam_angle = 1,
  k = 4/3,
  re = 6378,
  rp = 6357
)
}
\arguments{
\item{scan}{a scan (sweep) of class scan}

\item{vp}{A \code{vp} object}

\item{quantity}{Character. Profile quantity on which to base range
corrections, either \code{eta} or \code{dens}.}

\item{param}{reflectivity Character. Scan parameter on which to base range
corrections. Typically the same parameter from which animal densities are
estimated in \code{vp}. Either \code{DBZH}, \code{DBZV}, \code{DBZ}, \code{TH}, or \code{TV}.}

\item{lat}{Latitude of the radar, in degrees. If missing taken from \code{pvol}.}

\item{lon}{Latitude of the radar, in degrees. If missing taken from \code{pvol}.}

\item{antenna}{Numeric. Radar antenna height, in m. Default to antenna height
in \code{vp}.}

\item{beam_angle}{Numeric. Beam opening angle in degrees, typically the
angle between the half-power (-3 dB) points of the main lobe.}

\item{k}{Numeric. Standard refraction coefficient.}

\item{re}{Numeric. Earth equatorial radius, in km.}

\item{rp}{Numeric. Earth polar radius, in km.}
}
\value{
A \code{scan} object.
}
\description{
Adds expected eta to a scan
}
\keyword{internal}
