% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.scan.R
\name{plot.scan}
\alias{plot.scan}
\title{Plot a scan (\code{scan}) in polar coordinates}
\usage{
\method{plot}{scan}(
  x,
  param,
  xlim = c(0, 1e+05),
  ylim = c(0, 360),
  zlim = c(-20, 20),
  na.value = "transparent",
  ...
)
}
\arguments{
\item{x}{A \code{scan} object.}

\item{param}{Character. Scan parameter to plot, e.g. \code{DBZH} or \code{VRADH}. See
\code{\link[=summary.param]{summary.param()}} for commonly available parameters.}

\item{xlim}{Numeric vector of length 2. Range of x values (range, distance to
radar) to plot.}

\item{ylim}{Numeric vector of length 2. Range of y values (azimuth) to plot.}

\item{zlim}{Numeric vector of length 2. The range of parameter values to
plot. Defaults to parameter specific limits for plotting, not full range of data.}

\item{na.value}{Character. \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} parameter to set the color of
\code{NA} values.}

\item{...}{Arguments passed to \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.}
}
\value{
No return value, side effect is a plot.
}
\description{
Plots a scan (\code{scan}) in polar coordinates. To plot in Cartesian coordinates,
see \code{\link[=project_as_ppi]{project_as_ppi()}}.
}
\details{
Available scan parameters for plotting can by printed to screen
by \code{summary(x)}. Commonly available parameters are:
\itemize{
\item \code{DBZH}, \code{DBZ}: (Logged) reflectivity factor (dBZ)
\item \code{TH}, \code{T}: (Logged) uncorrected reflectivity factor (dBZ)
\item \code{VRADH}, \code{VRAD}: Radial velocity (m/s). Radial velocities towards the radar
are negative, while radial velocities away from the radar are positive
\item \code{RHOHV}: Correlation coefficient (unitless). Correlation between vertically
polarized and horizontally polarized reflectivity factor
\item \code{PHIDP}: Differential phase (degrees)
\item \code{ZDR}: (Logged) differential reflectivity (dB)
The scan parameters are named according to the OPERA data information
model (ODIM), see Table 16 in the
\href{https://github.com/adokter/vol2bird/blob/master/doc/OPERA2014_O4_ODIM_H5-v2.2.pdf}{ODIM specification}.
}
}
\examples{
# Plot reflectivity
plot(example_scan, param = "DBZH")

\donttest{
# Change the range of reflectivities to plot, from -10 to 10 dBZ
plot(example_scan, param = "DBZH", zlim = c(-10, 10))

# Change the scale name, change the color palette to Viridis colors
plot(example_scan, param = "DBZH", zlim = c(-10, 10)) +
  viridis::scale_fill_viridis(name = "dBZ")
}
}
