% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logltest.R
\name{logl_test}
\alias{logl_test}
\title{Conduct a log-likelihood test for comparing terms in ASReml-R models}
\usage{
logl_test(
  model.obj,
  rand.terms = NULL,
  resid.terms = NULL,
  decimals = 3,
  numeric = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{model.obj}{An ASReml-R model object}

\item{rand.terms}{Character vector of random terms to test. Default is NULL.}

\item{resid.terms}{Character vector of residual terms to test. Default is NULL.}

\item{decimals}{Number of decimal places to round p-values. Default is 3.}

\item{numeric}{Logical. Should p-values be returned as numeric? Default is FALSE (formatted).}

\item{quiet}{Logical. Suppress model update messages and warnings? Default is FALSE.}
}
\value{
A data frame of terms and corresponding log-likelihood ratio test p-values.
}
\description{
Conduct a log-likelihood test for comparing terms in ASReml-R models
}
