% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_5_advance.R
\name{granger_test}
\alias{granger_test}
\title{Granger causality test (bivariate).}
\usage{
granger_test(formula, data, lags = 1:5, test.reverse = TRUE, file = NULL, ...)
}
\arguments{
\item{formula}{Model formula like \code{y ~ x}.}

\item{data}{Data frame.}

\item{lags}{Time lags. Defaults to \code{1:5}.}

\item{test.reverse}{Whether to test reverse causality. Defaults to \code{TRUE}.}

\item{file}{File name of MS Word (\code{".doc"}).}

\item{...}{Arguments passed on to \code{\link[lmtest:grangertest]{lmtest::grangertest()}}. For example, you may use \emph{robust} standard errors by specifying the \code{vcov} argument (see \href{https://github.com/psychbruce/bruceR/issues/23}{GitHub Issue #23}).}
}
\value{
A data frame of results.
}
\description{
Granger test of predictive causality (between two time series) using \code{\link[lmtest:grangertest]{lmtest::grangertest()}}.
}
\details{
Granger causality test examines whether the lagged values of a predictor have an incremental role in predicting (i.e., help to predict) an outcome when controlling for the lagged values of the outcome. Granger causality does not represent a true causal effect.
}
\examples{
granger_test(chicken ~ egg, data=lmtest::ChickEgg)
granger_test(chicken ~ egg, data=lmtest::ChickEgg, lags=1:10, file="Granger.doc")
unlink("Granger.doc")  # delete file for code check

}
\seealso{
\code{\link[=ccf_plot]{ccf_plot()}}

\code{\link[=granger_causality]{granger_causality()}}
}
