% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R, R/aliases.R
\name{bs4Carousel}
\alias{bs4Carousel}
\alias{bs4CarouselItem}
\alias{carousel}
\alias{carouselItem}
\title{Bootstrap 4 carousel}
\usage{
bs4Carousel(..., id, indicators = TRUE, width = 12, .list = NULL)

bs4CarouselItem(..., caption = NULL, active = FALSE)

carousel(..., id, indicators = TRUE, width = 12, .list = NULL)

carouselItem(..., caption = NULL, active = FALSE)
}
\arguments{
\item{...}{Element such as images, iframe, ...}

\item{id}{Unique carousel id.}

\item{indicators}{Whether to display left and right indicators.}

\item{width}{Carousel width. Between 1 and 12.}

\item{.list}{Should you need to pass \link{carouselItem} via \link{lapply} or similar,
put these item here instead of passing them in ...}

\item{caption}{Item caption.}

\item{active}{Whether the item is active or not at start.}
}
\description{
\link{carousel} creates a carousel container to display media content.

\link{carouselItem} creates a carousel item to insert in a \link{carousel}
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)

 shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(
      carousel(
       id = "mycarousel",
       carouselItem(
        caption = "Item 1",
        tags$img(src = "placeholders/500x500.png")
       ),
       carouselItem(
        caption = "Item 2",
        tags$img(src = "placeholders/500x500.png")
       )
      )
     ),
     title = "Carousel"
   ),
   server = function(input, output) { }
 )
}

}
\seealso{
Other boxWidgets: 
\code{\link{attachmentBlock}()},
\code{\link{bs4CardLabel}()},
\code{\link{bs4CardSidebar}()},
\code{\link{bs4SocialCard}()},
\code{\link{bs4Timeline}()},
\code{\link{cardDropdown}()},
\code{\link{cardProfile}()},
\code{\link{descriptionBlock}()},
\code{\link{userPost}()}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
\concept{boxWidgets}
